/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.simulation.client.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import java.util.function.Supplier;
import org.bidib.jbidibc.messages.utils.NodeUtils;
import org.bidib.jbidibc.simulation.SimulatorNode;
import org.bidib.jbidibc.simulation.nodes.Simulation;
import org.bidib.wizard.api.model.NodeInterface;
import org.bidib.wizard.api.model.connection.BidibConnection;
import org.bidib.wizard.api.model.connection.SimulationBidibConnection;
import org.bidib.wizard.core.service.ConnectionService;
import org.bidib.wizard.simulation.client.controller.SimulationExport;
import org.bidib.wizard.simulation.client.view.SimulationView;
import org.bidib.wizard.simulation.client.view.SimulatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SimulationController
implements SimulatorProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimulationController.class);
    private final DockingDesktop desktop;
    private SimulationView simulationView;
    @Autowired
    private ConnectionService connectionService;
    private final Supplier<String> connectionId;

    public SimulationController(DockingDesktop desktop, Supplier<String> connectionId) {
        this.desktop = desktop;
        this.connectionId = connectionId;
    }

    public void start() {
        if (this.simulationView != null) {
            LOGGER.info("The simulation view is available already.");
            return;
        }
        LOGGER.info("Create new instance of simulation view.");
        this.simulationView = new SimulationView(this, this.desktop);
        this.restoreSimulationView();
    }

    @Override
    public void restoreSimulationView() {
    }

    private Dockable getTabPanel(DockingDesktop desktop) {
        DockableState[] dockables;
        Dockable tabPanel = null;
        for (DockableState dockable : dockables = desktop.getDockables()) {
            if (!dockable.getDockable().getDockKey().getKey().equals("tabPanel")) continue;
            LOGGER.info("Found tabPanel.");
            tabPanel = dockable.getDockable();
            break;
        }
        return tabPanel;
    }

    public void activate(NodeInterface node) {
        if (this.simulationView != null) {
            this.simulationView.activate(node, this.desktop);
        }
    }

    @Override
    public SimulatorNode getSimulator(NodeInterface node) {
        String nodeAddress = NodeUtils.formatAddress((byte[])node.getNode().getAddr());
        BidibConnection connection = this.connectionService.find(this.connectionId.get());
        if (connection.isSimulation()) {
            SimulationBidibConnection simulationBidibConnection = (SimulationBidibConnection)connection;
            return simulationBidibConnection.getSimulator(nodeAddress);
        }
        return null;
    }

    @Override
    public Simulation exportNodeTreeToSimulation() {
        LOGGER.info("Export simulation.");
        BidibConnection connection = this.connectionService.find(this.connectionId.get());
        Simulation simulation = new SimulationExport().exportNodeTreeToSimulation(connection);
        LOGGER.info("Prepared simulation: {}", (Object)simulation);
        return simulation;
    }
}

