/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.bidib.wizard.spy.BidibSpy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidibSpyLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibSpyLauncher.class);

    public void reloadLoggerConfiguration(String preferencesPath) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)context);
            context.reset();
            File logbackFile = new File(preferencesPath, "logback-proxy.xml");
            if (!logbackFile.exists()) {
                logbackFile = new File("logback-proxy.xml");
            }
            LOGGER.info("logbackFile: {}", (Object)logbackFile.getAbsolutePath());
            InputStream logbackConfig = null;
            if (logbackFile.exists()) {
                try {
                    logbackConfig = new BufferedInputStream(new FileInputStream(logbackFile));
                }
                catch (FileNotFoundException ex) {
                    LOGGER.warn("Load user-defined logback configuration failed.", (Throwable)ex);
                }
            }
            if (logbackConfig == null) {
                LOGGER.info("Use default logback config.");
                logbackConfig = BidibSpyLauncher.class.getResourceAsStream("/config/logback-proxy-default.xml");
            } else {
                LOGGER.info("Using user-defined logback config.");
            }
            configurator.doConfigure(logbackConfig);
        }
        catch (JoranException joranException) {
            // empty catch block
        }
        StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String preferencesPath = System.getProperty("bidib.preferencesPath");
                if (StringUtils.isBlank((String)preferencesPath) && StringUtils.isBlank((String)(preferencesPath = System.getenv("bidib.preferencesPath")))) {
                    preferencesPath = System.getProperty("user.home");
                    System.setProperty("bidib.preferencesPath", preferencesPath);
                }
                new BidibSpyLauncher().reloadLoggerConfiguration(preferencesPath);
                new BidibSpy().startApp(args);
            }
        });
    }
}

