/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy.preferences.controller;

import java.awt.Frame;
import org.apache.commons.configuration2.Configuration;
import org.bidib.wizard.spy.BidibSpyConfig;
import org.bidib.wizard.spy.preferences.model.PreferencesModel;
import org.bidib.wizard.spy.preferences.view.PreferencesView;
import org.bidib.wizard.spy.preferences.view.listener.PreferencesViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesController.class);
    private final Frame parent;

    public PreferencesController(Frame parent) {
        this.parent = parent;
    }

    public void start(final BidibSpyConfig config) {
        LOGGER.debug("Start the preferences controller.");
        final PreferencesModel model = this.createFromConfig(config);
        PreferencesViewListener listener = new PreferencesViewListener(){

            @Override
            public void save() {
                LOGGER.info("Save the configuration.");
                PreferencesController.this.updateConfig(config, "yaml", model);
                config.saveConfig("yaml");
            }

            @Override
            public void cancel() {
            }
        };
        PreferencesView view = new PreferencesView(this.parent, model, listener);
        LOGGER.info("After show view ...");
    }

    protected PreferencesModel createFromConfig(BidibSpyConfig config) {
        PreferencesModel preferencesModel = new PreferencesModel();
        String interfacePort = config.getConfig().getString("spy.interfacePort");
        String proxyPort = config.getConfig().getString("spy.proxyPort");
        preferencesModel.setInterfacePort(interfacePort);
        preferencesModel.setProxyPort(proxyPort);
        return preferencesModel;
    }

    protected void updateConfig(BidibSpyConfig spyConfig, String configName, PreferencesModel preferencesModel) {
        Configuration conf = spyConfig.getConfig().getConfiguration(configName);
        conf.setProperty("spy.interfacePort", (Object)preferencesModel.getInterfacePort());
        conf.setProperty("spy.proxyPort", (Object)preferencesModel.getProxyPort());
    }
}

