/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy.preferences.view;

import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.common.base.Preconditions;
import java.text.Format;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringConverter
implements BindingConverter<Number, String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringConverter.class);
    private final Format format;

    public StringConverter(Format format) {
        this.format = (Format)Preconditions.checkNotNull((Object)format, (String)"The format must not be null.");
    }

    public String targetValue(Number sourceValue) {
        if (sourceValue != null) {
            if (sourceValue instanceof Byte) {
                Byte byteValue = (Byte)sourceValue;
                sourceValue = ByteUtils.getInt((byte)byteValue);
            }
            return this.format.format(sourceValue);
        }
        return null;
    }

    public Number sourceValue(String targetValue) {
        try {
            if (StringUtils.isNotBlank((CharSequence)targetValue)) {
                return Integer.valueOf(targetValue);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Cannot parse the target value {}", (Object)targetValue);
        }
        return null;
    }
}

