/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.com0com.BidibPortProvider;
import org.bidib.jbidibc.com0com.BidibPortStatusListener;
import org.bidib.jbidibc.debug.DebugReaderFactory;
import org.bidib.wizard.spy.BidibSpyConfig;
import org.bidib.wizard.spy.preferences.controller.PreferencesController;
import org.bidib.wizard.spy.tray.Tray;
import org.bidib.wizard.spy.tray.TrayActionExecutor;
import org.bidib.wizard.spy.tray.TrayNotificationController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidibSpy
implements TrayActionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibSpy.class);
    private Tray tray;
    private String interfacePort;
    private String proxyPort;
    private String serialPortProvider;
    private BidibPortProvider provider;
    private BidibSpyConfig config = new BidibSpyConfig(null);
    private TrayNotificationController notificationController;
    private AtomicBoolean connectEnabled = new AtomicBoolean();
    protected final ScheduledExecutorService reconnectProxyWorker = Executors.newScheduledThreadPool(1);
    private BidibPortStatusListener.PortStatus latestPortStatus;

    public void startApp(String[] args) {
        this.config.loadConfig();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            LOGGER.error("Change to use system look and feel failed.", (Throwable)ex);
        }
        this.tray = new Tray(this);
        this.tray.init();
        this.notificationController = new TrayNotificationController();
        this.notificationController.start(this.tray);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                LOGGER.info("Shutdown hook is executed.");
                BidibSpy.this.exit();
            }
        });
        this.notificationController.addInfoNotification("BiDiB-Wizard-Spy", "The spy is started. Use the tray menu to connect.");
    }

    @Override
    public void exit() {
        this.disconnect();
        if (this.tray != null) {
            this.tray.cleanup();
            this.tray = null;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            System.exit(0);
        }
    }

    @Override
    public void showPreferences() {
        PreferencesController controller = new PreferencesController(JOptionPane.getFrameForComponent(null));
        controller.start(this.config);
    }

    @Override
    public void connect() {
        try {
            LOGGER.info("Create the provider the interface and proxy port.");
            this.provider = new BidibPortProvider();
            this.provider.addStatusListener(new BidibPortStatusListener(){

                public void statusChanged(BidibPortStatusListener.PortStatus portStatus) {
                    LOGGER.info("The status of the proxy connection has been changed: {}", (Object)portStatus);
                    BidibSpy.this.tray.setPortStatus(portStatus);
                    if (BidibPortStatusListener.PortStatus.DISCONNECTED == portStatus && BidibSpy.this.latestPortStatus != portStatus) {
                        BidibSpy.this.latestPortStatus = portStatus;
                        if (BidibSpy.this.connectEnabled.get()) {
                            LOGGER.info("Automatic reconnect of proxy port is enabled. Reconnect the proxy port.");
                            BidibSpy.this.reconnectProxyWorker.schedule(() -> SwingUtilities.invokeLater(() -> BidibSpy.this.provider.reconnectProxyPort()), 5L, TimeUnit.SECONDS);
                        } else {
                            LOGGER.info("Automatic reconnect of proxy port is not enabled.");
                        }
                    } else if (BidibSpy.this.latestPortStatus != portStatus) {
                        LOGGER.info("Set the latest port status: {}", (Object)portStatus);
                        BidibSpy.this.latestPortStatus = portStatus;
                    }
                }
            });
            DebugReaderFactory.SerialImpl serialImpl = DebugReaderFactory.SerialImpl.SCM;
            if (StringUtils.isNotBlank((CharSequence)this.serialPortProvider)) {
                switch (this.serialPortProvider) {
                    case "RXTX": {
                        serialImpl = DebugReaderFactory.SerialImpl.RXTX;
                        LOGGER.info("Set the system property: gnu.io.rxtx.SerialPorts, value: {}", (Object)(this.proxyPort + ";" + this.interfacePort));
                        System.setProperty("gnu.io.rxtx.SerialPorts", this.proxyPort + ":" + this.interfacePort);
                        break;
                    }
                    case "PUREJAVACOMM": {
                        serialImpl = DebugReaderFactory.SerialImpl.PUREJAVACOMM;
                        break;
                    }
                }
            }
            LOGGER.info("Use the serial port provider impl: {}", (Object)serialImpl);
            this.provider.start(this.interfacePort, this.proxyPort, serialImpl);
            this.connectEnabled.set(true);
            this.notificationController.addInfoNotification("BiDiB-Wizard-Spy", "Connect to interface and proxy port passed.");
            LOGGER.info("Start interface and proxy port passed.");
        }
        catch (Exception ex) {
            LOGGER.warn("Connect to interface and proxy port failed.", (Throwable)ex);
            this.notificationController.addErrorNotification("BiDiB-Wizard-Spy", "Connect to interface and proxy port failed.");
            this.stopProvider();
        }
    }

    @Override
    public void disconnect() {
        LOGGER.info("Disconnect is called from tray.");
        this.connectEnabled.set(false);
        this.stopProvider();
        this.notificationController.addInfoNotification("BiDiB-Wizard-Spy", "Disconnect from interface and proxy port passed.");
    }

    private void stopProvider() {
        try {
            if (this.provider != null) {
                LOGGER.info("Stop the provider.");
                this.provider.stop();
                this.provider = null;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Stop provider failed.", (Throwable)ex);
        }
    }

    @Override
    public boolean isConnectEnabled() {
        return this.provider == null && this.isSpyConfigValid();
    }

    @Override
    public boolean isDisconnectEnabled() {
        return this.provider != null;
    }

    private boolean isSpyConfigValid() {
        this.interfacePort = this.config.getConfig().getString("spy.interfacePort");
        this.proxyPort = this.config.getConfig().getString("spy.proxyPort");
        this.serialPortProvider = this.config.getConfig().getString("spy.serialPortProvider");
        LOGGER.info("Loaded properties, interfacePort: {}, proxyPort: {}, serialPortProvider: {}", new Object[]{this.interfacePort, this.proxyPort, this.serialPortProvider});
        if (StringUtils.isBlank((CharSequence)this.interfacePort) || StringUtils.isBlank((CharSequence)this.proxyPort)) {
            LOGGER.error("The configuration properties has missing valus for 'interfacePort' and/or 'proxyPort'. Add these values to properties file: {}", (Object)"bidib-spy.yml");
            return false;
        }
        return true;
    }
}

