/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy.preferences.view;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import org.bidib.wizard.common.locale.Resources;
import org.bidib.wizard.spy.preferences.model.PreferencesModel;
import org.bidib.wizard.spy.preferences.view.EscapeDialog;
import org.bidib.wizard.spy.preferences.view.MiscPanel;
import org.bidib.wizard.spy.preferences.view.listener.PreferencesViewListener;

public class PreferencesView
extends EscapeDialog {
    private static final long serialVersionUID = -1L;
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private final JTabbedPane tabbedPane;
    private final MiscPanel miscPanel;

    public PreferencesView(Frame parent, PreferencesModel model, final PreferencesViewListener listener) {
        super(parent, Resources.getString(PreferencesView.class, (String)"title"), false);
        FormBuilder dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows("p, 3dlu, fill:200px:grow, 3dlu, p", new Object[0]);
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        dialogBuilder.add(Resources.getString(this.getClass(), (String)"preferences.title"), new Object[0]).xyw(1, 1, 3);
        this.tabbedPane = new JTabbedPane();
        this.miscPanel = new MiscPanel(model);
        this.tabbedPane.addTab(Resources.getString(this.getClass(), (String)"tab-misc"), null, this.miscPanel.createPanel(), Resources.getString(this.getClass(), (String)"tab-misc.tooltip"));
        this.tabbedPane.setMnemonicAt(0, 49);
        dialogBuilder.add((Component)this.tabbedPane).xyw(1, 3, 3);
        JButton save = new JButton(Resources.getString(this.getClass(), (String)"save"));
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesView.this.setVisible(false);
                PreferencesView.this.fireSave(listener);
            }
        });
        JButton cancel = new JButton(Resources.getString(this.getClass(), (String)"cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesView.this.setVisible(false);
                PreferencesView.this.fireCancel(listener);
            }
        });
        JPanel buttons = ((ButtonBarBuilder)new ButtonBarBuilder().addGlue().addButton(new JComponent[]{save, cancel}).border((Border)Paddings.DLU4)).build();
        dialogBuilder.add((Component)buttons).xyw(1, 5, 3);
        JPanel contentPanel = dialogBuilder.build();
        this.getContentPane().add(contentPanel);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setMinimumSize(this.getSize());
        this.setVisible(true);
    }

    protected void fireCancel(PreferencesViewListener listener) {
        listener.cancel();
    }

    private void fireSave(PreferencesViewListener listener) {
        listener.save();
    }
}

