/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy.tray;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.TrayIcon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JXTrayIcon
extends TrayIcon {
    private JPopupMenu menu;
    private static JDialog dialog = new JDialog((Frame)null, "TrayDialog");
    private PopupMenuListener popupListener = new PopupMenuListener(){

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JXTrayIcon.this.updatePopupMenu(e);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            dialog.setVisible(false);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            dialog.setVisible(false);
        }
    };

    public JXTrayIcon(Image image) {
        super(image);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                JXTrayIcon.this.showJPopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JXTrayIcon.this.showJPopupMenu(e);
            }
        });
    }

    protected void updatePopupMenu(PopupMenuEvent e) {
    }

    private void showJPopupMenu(MouseEvent e) {
        if (e.isPopupTrigger() && this.menu != null) {
            Dimension size = this.menu.getPreferredSize();
            dialog.setLocation(e.getX(), e.getY() - size.height);
            dialog.setVisible(true);
            this.menu.show(dialog.getContentPane(), 0, 0);
            dialog.toFront();
        }
    }

    public JPopupMenu getJPopuMenu() {
        return this.menu;
    }

    public void setJPopuMenu(JPopupMenu menu) {
        if (this.menu != null) {
            this.menu.removePopupMenuListener(this.popupListener);
        }
        this.menu = menu;
        menu.addPopupMenuListener(this.popupListener);
    }

    static {
        dialog.setUndecorated(true);
        dialog.setAlwaysOnTop(true);
    }
}

