/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy.tray;

import java.awt.TrayIcon;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.bidib.wizard.spy.tray.Tray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrayNotificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrayNotificationController.class);
    private NotificationQueueWatcher watcher;
    private BlockingQueue<BalloonMessage> notificationQueue = new LinkedBlockingQueue<BalloonMessage>();
    private final ScheduledExecutorService hotplugWorker = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> watcherFuture;

    public void start(Tray tray) {
        SwingUtilities.invokeLater(() -> {
            try {
                LOGGER.info("Start the watcher for events.");
                this.watcher = new NotificationQueueWatcher(tray);
                this.watcherFuture = this.hotplugWorker.schedule(this.watcher, 0L, TimeUnit.MILLISECONDS);
                LOGGER.info("Create and start TrayNotificationEventWatcher passed.");
            }
            catch (Exception ex) {
                LOGGER.warn("Start TrayNotificationEventWatcher failed.", (Throwable)ex);
            }
        });
    }

    public void addInfoNotification(String caption, String message) {
        BalloonMessage alert = new BalloonMessage(caption, message, TrayIcon.MessageType.INFO);
        this.notificationQueue.add(alert);
    }

    public void addErrorNotification(String caption, String message) {
        BalloonMessage alert = new BalloonMessage(caption, message, TrayIcon.MessageType.ERROR);
        this.notificationQueue.add(alert);
    }

    public void stopWatcher() {
        if (this.watcher != null) {
            LOGGER.info("Stop the watcher.");
            try {
                this.watcher.stop();
            }
            catch (Exception ex) {
                LOGGER.warn("Stop watcher failed.", (Throwable)ex);
            }
            if (this.watcherFuture != null) {
                LOGGER.info("Wait for termination of watcher.");
                try {
                    this.watcherFuture.cancel(true);
                    this.watcherFuture.get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    LOGGER.warn("Stop watcher failed.", (Throwable)ex);
                }
                this.watcherFuture = null;
                LOGGER.info("Watcher has terminated.");
            }
        }
    }

    private final class NotificationQueueWatcher
    implements Runnable {
        private final Tray tray;
        AtomicBoolean leaveLoop = new AtomicBoolean(false);

        public NotificationQueueWatcher(Tray tray) {
            this.tray = tray;
        }

        public void stop() {
            this.leaveLoop.set(true);
        }

        @Override
        public void run() {
            LOGGER.info("Start the notification queue watcher.");
            do {
                try {
                    BalloonMessage alert = (BalloonMessage)TrayNotificationController.this.notificationQueue.take();
                    if (alert == null || this.leaveLoop.get()) continue;
                    LOGGER.info("Show alert: {}", (Object)alert);
                    SwingUtilities.invokeLater(() -> {
                        LOGGER.info("Show alert: {}", (Object)alert);
                        try {
                            this.tray.showBalloonMessage(alert.caption, alert.message, alert.type);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Show alert in tray failed.", (Throwable)ex);
                        }
                    });
                }
                catch (InterruptedException ex) {
                    LOGGER.info("Wait for notification was interrupted. Leave the loop.");
                    this.leaveLoop.set(true);
                }
                catch (Exception ex) {
                    LOGGER.info("Wait for notification caused an exception.", (Throwable)ex);
                }
            } while (!this.leaveLoop.get());
        }
    }

    public static final class BalloonMessage {
        String caption;
        String message;
        TrayIcon.MessageType type;

        public BalloonMessage(String caption, String message, TrayIcon.MessageType type) {
            this.caption = caption;
            this.message = message;
            this.type = type;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

