/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy.tray;

import java.awt.TrayIcon;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import org.bidib.wizard.spy.tray.Tray;
import org.bidib.wizard.spy.tray.TrayNotificationController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrayNotificationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrayNotificationController.class);
    private NotificationQueueWatcher watcher;
    private BlockingQueue<BalloonMessage> notificationQueue = new LinkedBlockingQueue();
    private final ScheduledExecutorService hotplugWorker = Executors.newScheduledThreadPool(1);
    private ScheduledFuture<?> watcherFuture;

    public void start(Tray tray) {
        SwingUtilities.invokeLater(() -> {
            try {
                LOGGER.info("Start the watcher for events.");
                this.watcher = new NotificationQueueWatcher(this, tray);
                this.watcherFuture = this.hotplugWorker.schedule((Runnable)this.watcher, 0L, TimeUnit.MILLISECONDS);
                LOGGER.info("Create and start TrayNotificationEventWatcher passed.");
            }
            catch (Exception ex) {
                LOGGER.warn("Start TrayNotificationEventWatcher failed.", (Throwable)ex);
            }
        });
    }

    public void addInfoNotification(String caption, String message) {
        BalloonMessage alert = new BalloonMessage(caption, message, TrayIcon.MessageType.INFO);
        this.notificationQueue.add(alert);
    }

    public void addErrorNotification(String caption, String message) {
        BalloonMessage alert = new BalloonMessage(caption, message, TrayIcon.MessageType.ERROR);
        this.notificationQueue.add(alert);
    }

    public void stopWatcher() {
        if (this.watcher != null) {
            LOGGER.info("Stop the watcher.");
            try {
                this.watcher.stop();
            }
            catch (Exception ex) {
                LOGGER.warn("Stop watcher failed.", (Throwable)ex);
            }
            if (this.watcherFuture != null) {
                LOGGER.info("Wait for termination of watcher.");
                try {
                    this.watcherFuture.cancel(true);
                    this.watcherFuture.get(2000L, TimeUnit.MILLISECONDS);
                }
                catch (Exception ex) {
                    LOGGER.warn("Stop watcher failed.", (Throwable)ex);
                }
                this.watcherFuture = null;
                LOGGER.info("Watcher has terminated.");
            }
        }
    }
}

