package org.bidib.wizard.spy.preferences.view;

import java.util.function.Consumer;

import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ChangeDocumentListener implements DocumentListener {

    private final Consumer<Document> callback;

    public ChangeDocumentListener(final Consumer<Document> callback) {
        this.callback = callback;
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.callback.accept(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.callback.accept(e.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.callback.accept(e.getDocument());
    }

}
