/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy.tray;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.base.BidibPortStatusListener;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.common.utils.ImageUtils;
import org.bidib.wizard.spy.tray.JXTrayIcon;
import org.bidib.wizard.spy.tray.Tray;
import org.bidib.wizard.spy.tray.TrayActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tray {
    private static final Logger LOGGER = LoggerFactory.getLogger(Tray.class);
    private JXTrayIcon trayIcon;
    private ImageIcon wizardTrayIcon;
    private ImageIcon wizardTrayIconConnected;
    private ImageIcon wizardTrayIconDisconnected;
    private final TrayActionExecutor trayActionExecutor;
    private JMenuItem connectItem;
    private JMenuItem disconnectItem;

    public Tray(TrayActionExecutor trayActionExecutor) {
        this.trayActionExecutor = trayActionExecutor;
    }

    public void init() {
        SystemTray systemTray = SystemTray.getSystemTray();
        Dimension dimension = systemTray.getTrayIconSize();
        this.wizardTrayIcon = ImageUtils.createImageIcon(Tray.class, (String)"/icons/wizard/logo.png", (int)dimension.width, (int)dimension.height);
        this.wizardTrayIconConnected = ImageUtils.createImageIcon(Tray.class, (String)"/icons/wizard/proxy-connected.png", (int)dimension.width, (int)dimension.height);
        this.wizardTrayIconDisconnected = ImageUtils.createImageIcon(Tray.class, (String)"/icons/wizard/proxy-disconnected.png", (int)dimension.width, (int)dimension.height);
        this.trayIcon = new /* Unavailable Anonymous Inner Class!! */;
        this.trayIcon.setToolTip(Resources.getString(Tray.class, (String)"application.name"));
        this.trayIcon.setJPopuMenu(this.createJPopupMenu());
        try {
            systemTray.add((TrayIcon)this.trayIcon);
        }
        catch (AWTException e) {
            LOGGER.error("Tray icon failure", (Throwable)e);
        }
    }

    public void showBalloonMessage(String caption, String message, TrayIcon.MessageType type) {
        this.trayIcon.displayMessage(caption, message, type);
    }

    public void cleanup() {
        LOGGER.info("Removing system tray icon");
        try {
            SwingUtilities.invokeLater((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            LOGGER.info("System tray icon removed");
        }
        catch (Exception ex) {
            LOGGER.warn("Remove system tray icon failed.", (Throwable)ex);
        }
        catch (Error ex) {
            LOGGER.warn("Remove system tray icon failed.", (Throwable)ex);
        }
    }

    private JPopupMenu createJPopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem preferencesItem = new JMenuItem(Resources.getString(Tray.class, (String)"preferencesMenuItemLabelText"));
        popup.add(preferencesItem);
        this.connectItem = new JMenuItem(Resources.getString(Tray.class, (String)"connectMenuItemLabelText"), this.wizardTrayIconConnected);
        this.connectItem.setEnabled(this.trayActionExecutor.isConnectEnabled());
        popup.add(this.connectItem);
        this.disconnectItem = new JMenuItem(Resources.getString(Tray.class, (String)"disconnectMenuItemLabelText"), this.wizardTrayIconDisconnected);
        this.disconnectItem.setEnabled(this.trayActionExecutor.isDisconnectEnabled());
        popup.add(this.disconnectItem);
        JMenuItem exitItem = new JMenuItem(Resources.getString(Tray.class, (String)"exitMenuItemLabelText"));
        exitItem.setEnabled(true);
        popup.add(exitItem);
        exitItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        preferencesItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.connectItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.disconnectItem.addActionListener((ActionListener)new /* Unavailable Anonymous Inner Class!! */);
        return popup;
    }

    protected void updatePopupMenu() {
        if (this.connectItem != null) {
            this.connectItem.setEnabled(this.trayActionExecutor.isConnectEnabled());
        }
        if (this.disconnectItem != null) {
            this.disconnectItem.setEnabled(this.trayActionExecutor.isDisconnectEnabled());
        }
    }

    public void setPortStatus(BidibPortStatusListener.PortStatus portStatus) {
        SwingUtilities.invokeLater(() -> {
            switch (7.$SwitchMap$org$bidib$jbidibc$messages$base$BidibPortStatusListener$PortStatus[portStatus.ordinal()]) {
                case 1: {
                    this.trayIcon.setImage(this.wizardTrayIconConnected.getImage());
                    break;
                }
                default: {
                    this.trayIcon.setImage(this.wizardTrayIconDisconnected.getImage());
                }
            }
        });
    }
}

