/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.configuration2.CombinedConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.YAMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidibSpyConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibSpyConfig.class);
    public static final String DEFAULT_CONFIG_FILENAME = "bidib-spy.yml";
    public static final String CONFIG_YAML_FILE = "yaml";
    private CombinedConfiguration config = new CombinedConfiguration();
    private final String configFileName;

    public BidibSpyConfig(String configFileName) {
        if (StringUtils.isBlank((CharSequence)configFileName)) {
            configFileName = DEFAULT_CONFIG_FILENAME;
        }
        this.configFileName = configFileName;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    private String getPreferencesPath() {
        String preferencesPath = System.getProperty("bidib.preferencesPath");
        if (StringUtils.isBlank((CharSequence)preferencesPath) && StringUtils.isBlank((CharSequence)(preferencesPath = System.getenv("bidib.preferencesPath")))) {
            preferencesPath = System.getProperty("user.home");
            System.setProperty("bidib.preferencesPath", preferencesPath);
        }
        LOGGER.info("Resolved current preferences path: {}", (Object)preferencesPath);
        return preferencesPath;
    }

    public void loadConfig() {
        YAMLConfiguration yamlConfig = new YAMLConfiguration();
        this.config.addConfiguration((Configuration)yamlConfig, CONFIG_YAML_FILE);
        try {
            File propertiesFile = new File(this.getPreferencesPath(), this.configFileName);
            yamlConfig.read((Reader)new FileReader(propertiesFile));
        }
        catch (ConfigurationException cex) {
            LOGGER.warn("Load configuration properties failed.", (Throwable)cex);
        }
        catch (FileNotFoundException ex) {
            LOGGER.warn("Load configuration properties failed because YAML file was not found.", (Throwable)ex);
        }
    }

    public CombinedConfiguration getConfig() {
        return this.config;
    }

    public void saveConfig(String name) {
        Configuration subConfig = this.config.getConfiguration(name);
        if (subConfig instanceof FileBased) {
            FileBased fileBased = (FileBased)subConfig;
            File propertiesFile = new File(this.getPreferencesPath(), this.configFileName);
            try (FileWriter writer = new FileWriter(propertiesFile);){
                fileBased.write((Writer)writer);
            }
            catch (IOException ex) {
                LOGGER.warn("Write preferences data to file failed.", (Throwable)ex);
            }
            catch (ConfigurationException ex) {
                LOGGER.warn("Write preferences data to file failed.", (Throwable)ex);
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BidibProxyConfig, configFileName: ");
        sb.append(this.configFileName);
        return sb.toString();
    }
}

