package org.bidib.wizard.spy.preferences.view;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.spy.preferences.model.PreferencesModel;
import org.bidib.wizard.spy.preferences.view.listener.PreferencesViewListener;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;

public class PreferencesView extends EscapeDialog {

    private static final long serialVersionUID = -1L;

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";

    private final JTabbedPane tabbedPane;

    private final MiscPanel miscPanel;

    public PreferencesView(Frame parent, final PreferencesModel model, final PreferencesViewListener listener) {
        super(parent, Resources.getString(PreferencesView.class, "title"), false);

        FormBuilder dialogBuilder =
            FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows("p, 3dlu, fill:200px:grow, 3dlu, p");
        dialogBuilder.border(Paddings.TABBED_DIALOG);

        dialogBuilder.add(Resources.getString(getClass(), "preferences.title")).xyw(1, 1, 3);

        // create the tabbed pane for the preferences panels
        tabbedPane = new JTabbedPane();

        miscPanel = new MiscPanel(model);

        // add tabs
        tabbedPane
            .addTab(Resources.getString(getClass(), "tab-misc"), null/* icon */, miscPanel.createPanel(),
                Resources.getString(getClass(), "tab-misc.tooltip"));
        tabbedPane.setMnemonicAt(0, KeyEvent.VK_1);

        // add the tabbed pane to the dialog
        dialogBuilder.add(tabbedPane).xyw(1, 3, 3);

        // prepare buttons
        JButton save = new JButton(Resources.getString(getClass(), "save"));
        save.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                fireSave(listener);
            }
        });

        JButton cancel = new JButton(Resources.getString(getClass(), "cancel"));
        cancel.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                setVisible(false);
                fireCancel(listener);
            }
        });
        JPanel buttons = new ButtonBarBuilder().addGlue().addButton(save, cancel).border(Paddings.DLU4).build();

        dialogBuilder.add(buttons).xyw(1, 5, 3);

        JPanel contentPanel = dialogBuilder.build();

        getContentPane().add(contentPanel);

        pack();
        setLocationRelativeTo(parent);

        setMinimumSize(getSize());
        setVisible(true);
    }

    protected void fireCancel(final PreferencesViewListener listener) {
        listener.cancel();
    }

    private void fireSave(final PreferencesViewListener listener) {
        listener.save();
    }
}
