package org.bidib.wizard.spy.config;

import java.awt.EventQueue;
import java.util.Arrays;

import org.bidib.wizard.spy.BidibSpy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration
public class SpyConfiguration {

    private static final Logger LOGGER = LoggerFactory.getLogger(SpyConfiguration.class);

    @Bean
    ApplicationRunner applicationRunner(final ApplicationContext applicationContext) {

        LOGGER.info("Launch the application.");
        return args -> EventQueue.invokeLater(() -> {

            LOGGER.info("Start the application with args: {}", Arrays.asList(args.getSourceArgs()));
            bidibSpy().startApp(args.getSourceArgs());
        });
    }

    @Bean
    @Lazy
    BidibSpy bidibSpy() {
        BidibSpy bidibSpy = new BidibSpy();

        return bidibSpy;
    }
}
