package org.bidib.wizard.spy.preferences.view;

import java.awt.Insets;

import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingConstants;
import javax.swing.text.Document;

import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.spy.preferences.model.PreferencesModel;

import com.jgoodies.binding.adapter.Bindings;
import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.validation.view.ValidationComponentUtils;
import com.jidesoft.swing.DefaultOverlayable;
import com.jidesoft.swing.StyledLabelBuilder;

public class MiscPanel {

    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, fill:50dlu:grow";

    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref";

    private final PreferencesModel preferencesModel;

    private ValueModel interfacePortValueModel;

    private ValueModel proxyPortValueModel;

    private ValueModel serialPortProviderValueModel;

    private SelectionInList<String> serialPortProviderSelection;

    public MiscPanel(final PreferencesModel model) {
        this.preferencesModel = model;
    }

    public JPanel createPanel() {

        FormBuilder dialogBuilder =
            FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS).rows(ENCODED_DIALOG_ROW_SPECS);
        dialogBuilder.border(Paddings.TABBED_DIALOG);

        // prepare the panel content
        interfacePortValueModel =
            new PropertyAdapter<PreferencesModel>(preferencesModel, PreferencesModel.PROPERTY_INTERFACE_PORT, true);
        JTextField textInterfacePort = createTextField(interfacePortValueModel);

        final DefaultOverlayable textInterfacePortOverlayable = new DefaultOverlayable(textInterfacePort);
        textInterfacePortOverlayable
            .addOverlayComponent(
                StyledLabelBuilder
                    .createStyledLabel("{" + Resources.getString(getClass(), "interfacePort.prompt") + ":f:gray}"),
                SwingConstants.WEST);
        textInterfacePortOverlayable.setOverlayLocationInsets(new Insets(0, -5, 0, 5));

        final Document textDoc = textInterfacePort.getDocument();
        textDoc
            .addDocumentListener(
                new ChangeDocumentListener(doc -> textInterfacePortOverlayable.setOverlayVisible(doc.getLength() < 1)));
        textInterfacePortOverlayable.setOverlayVisible(textDoc.getLength() < 1);

        dialogBuilder.add(Resources.getString(getClass(), "interfacePort")).xy(1, 1);
        dialogBuilder.add(textInterfacePortOverlayable).xy(3, 1);

        ValidationComponentUtils.setMandatory(textInterfacePort, true);
        ValidationComponentUtils.setMessageKeys(textInterfacePort, "validation.interfaceport_key");

        proxyPortValueModel =
            new PropertyAdapter<PreferencesModel>(preferencesModel, PreferencesModel.PROPERTY_PROXY_PORT, true);
        JTextField textProxyPort = createTextField(proxyPortValueModel);

        final DefaultOverlayable textProxyPortOverlayable = new DefaultOverlayable(textProxyPort);
        textProxyPortOverlayable
            .addOverlayComponent(
                StyledLabelBuilder
                    .createStyledLabel("{" + Resources.getString(getClass(), "proxyPort.prompt") + ":f:gray}"),
                SwingConstants.WEST);
        textProxyPortOverlayable.setOverlayLocationInsets(new Insets(0, -5, 0, 5));

        final Document textProxyPortDoc = textProxyPort.getDocument();
        textProxyPortDoc
            .addDocumentListener(
                new ChangeDocumentListener(doc -> textProxyPortOverlayable.setOverlayVisible(doc.getLength() < 1)));
        textProxyPortOverlayable.setOverlayVisible(textProxyPortDoc.getLength() < 1);

        dialogBuilder.add(Resources.getString(getClass(), "proxyPort")).xy(1, 3);
        dialogBuilder.add(textProxyPortOverlayable).xy(3, 3);

        ValidationComponentUtils.setMandatory(textProxyPort, true);
        ValidationComponentUtils.setMessageKeys(textProxyPort, "validation.proxyport_key");

        // add some components
        final ArrayListModel<String> serialPortProvidersListModel = new ArrayListModel<>();
        serialPortProvidersListModel.add("SCM");
        serialPortProvidersListModel.add("RXTX");
        serialPortProvidersListModel.add("PUREJAVACOMM");

        serialPortProviderSelection = new SelectionInList<String>((ListModel<String>) serialPortProvidersListModel);

        serialPortProviderValueModel =
            new PropertyAdapter<PreferencesModel>(preferencesModel, PreferencesModel.PROPERTY_SERIAL_PORT_PROVIDER,
                true);

        ComboBoxAdapter<String> comboBoxAdapterSerialPortProvider =
            new ComboBoxAdapter<String>(serialPortProviderSelection, serialPortProviderValueModel);
        JComboBox<String> comboSerialPortProvider = new JComboBox<>();
        comboSerialPortProvider.setModel(comboBoxAdapterSerialPortProvider);

        dialogBuilder.add(Resources.getString(getClass(), "serialPortProvider")).xy(1, 5);
        dialogBuilder.add(comboSerialPortProvider).xy(3, 5);

        ValidationComponentUtils.setMandatory(comboSerialPortProvider, true);
        ValidationComponentUtils.setMessageKeys(comboSerialPortProvider, "validation.serialportprovider_key");

        JPanel contentPanel = dialogBuilder.build();

        return contentPanel;
    }

    /**
     * Creates and returns a text field with the content bound to the given ValueModel. Text changes are committed to
     * the model on focus lost.
     *
     * @param valueModel
     *            the model that provides the value
     * @return a text field that is bound to the given value model
     *
     * @throws NullPointerException
     *             if the valueModel is {@code null}
     *
     * @see #createTextField(ValueModel, boolean)
     */
    public static JTextField createTextField(ValueModel valueModel) {
        return createTextField(valueModel, true);
    }

    /**
     * Creates and returns a text field with the content bound to the given ValueModel. Text changes can be committed to
     * the model on focus lost or on every character typed.
     *
     * @param valueModel
     *            the model that provides the text value
     * @param commitOnFocusLost
     *            true to commit text changes on focus lost, false to commit text changes on every character typed
     * @return a text field that is bound to the given value model
     *
     * @throws NullPointerException
     *             if the valueModel is {@code null}
     *
     * @see #createTextField(ValueModel)
     */
    public static JTextField createTextField(ValueModel valueModel, boolean commitOnFocusLost) {
        JTextField textField = new JTextField();
        Bindings.bind(textField, valueModel, commitOnFocusLost);
        return textField;
    }
}
