/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.com0com.BidibPortProvider;
import org.bidib.jbidibc.debug.DebugReaderFactory;
import org.bidib.jbidibc.messages.base.BidibPortStatusListener;
import org.bidib.wizard.spy.BidibSpyConfig;
import org.bidib.wizard.spy.preferences.controller.PreferencesController;
import org.bidib.wizard.spy.tray.Tray;
import org.bidib.wizard.spy.tray.TrayActionExecutor;
import org.bidib.wizard.spy.tray.TrayNotificationController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BidibSpy
implements TrayActionExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(BidibSpy.class);
    private Tray tray;
    private String interfacePort;
    private String proxyPort;
    private String serialPortProvider;
    private BidibPortProvider provider;
    private BidibSpyConfig config = new BidibSpyConfig(null);
    private TrayNotificationController notificationController;
    private AtomicBoolean connectEnabled = new AtomicBoolean();
    protected final ScheduledExecutorService reconnectProxyWorker = Executors.newScheduledThreadPool(1);
    private BidibPortStatusListener.PortStatus latestPortStatus;

    public void startApp(String[] args) {
        this.config.loadConfig();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            LOGGER.error("Change to use system look and feel failed.", (Throwable)ex);
        }
        this.tray = new Tray((TrayActionExecutor)this);
        this.tray.init();
        this.notificationController = new TrayNotificationController();
        this.notificationController.start(this.tray);
        this.notificationController.addInfoNotification("BiDiB-Wizard-Spy", "The spy is started. Use the tray menu to connect.");
    }

    public void exit() {
        this.disconnect();
        if (this.tray != null) {
            this.tray.cleanup();
            this.tray = null;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            System.exit(0);
        }
    }

    public void showPreferences() {
        PreferencesController controller = new PreferencesController(JOptionPane.getFrameForComponent(null));
        controller.start(this.config);
    }

    public void connect() {
        try {
            LOGGER.info("Create the provider the interface and proxy port.");
            this.provider = new BidibPortProvider();
            this.provider.addStatusListener((BidibPortStatusListener)new /* Unavailable Anonymous Inner Class!! */);
            DebugReaderFactory.SerialImpl serialImpl = DebugReaderFactory.SerialImpl.SCM;
            if (StringUtils.isNotBlank((CharSequence)this.serialPortProvider)) {
                switch (this.serialPortProvider) {
                    case "RXTX": {
                        serialImpl = DebugReaderFactory.SerialImpl.RXTX;
                        String osName = System.getProperty("os.name");
                        String ports = null;
                        ports = osName.toLowerCase().indexOf("windows") == -1 ? this.proxyPort + ":" + this.interfacePort : this.proxyPort + ";" + this.interfacePort;
                        LOGGER.info("Set the system property: gnu.io.rxtx.SerialPorts, value: {}", (Object)ports);
                        System.setProperty("gnu.io.rxtx.SerialPorts", ports);
                        break;
                    }
                    case "PUREJAVACOMM": {
                        serialImpl = DebugReaderFactory.SerialImpl.PUREJAVACOMM;
                        break;
                    }
                }
            }
            LOGGER.info("Use the serial port provider impl: {}", (Object)serialImpl);
            this.provider.start(this.interfacePort, this.proxyPort, serialImpl);
            this.connectEnabled.set(true);
            this.notificationController.addInfoNotification("BiDiB-Wizard-Spy", "Connect to interface and proxy port passed.");
            LOGGER.info("Start interface and proxy port passed.");
        }
        catch (Exception ex) {
            LOGGER.warn("Connect to interface and proxy port failed.", (Throwable)ex);
            this.notificationController.addErrorNotification("BiDiB-Wizard-Spy", "Connect to interface and proxy port failed.");
            this.stopProvider();
        }
    }

    public void disconnect() {
        LOGGER.info("Disconnect is called from tray.");
        this.connectEnabled.set(false);
        this.stopProvider();
        this.notificationController.addInfoNotification("BiDiB-Wizard-Spy", "Disconnect from interface and proxy port passed.");
    }

    private void stopProvider() {
        try {
            if (this.provider != null) {
                LOGGER.info("Stop the provider.");
                this.provider.stop();
                this.provider = null;
            }
        }
        catch (Exception ex) {
            LOGGER.warn("Stop provider failed.", (Throwable)ex);
        }
    }

    public boolean isConnectEnabled() {
        return this.provider == null && this.isSpyConfigValid();
    }

    public boolean isDisconnectEnabled() {
        return this.provider != null;
    }

    private boolean isSpyConfigValid() {
        this.interfacePort = this.config.getConfig().getString("spy.interfacePort");
        this.proxyPort = this.config.getConfig().getString("spy.proxyPort");
        this.serialPortProvider = this.config.getConfig().getString("spy.serialPortProvider");
        LOGGER.info("Loaded properties, interfacePort: {}, proxyPort: {}, serialPortProvider: {}", new Object[]{this.interfacePort, this.proxyPort, this.serialPortProvider});
        if (StringUtils.isBlank((CharSequence)this.interfacePort) || StringUtils.isBlank((CharSequence)this.proxyPort)) {
            LOGGER.error("The configuration properties has missing valus for 'interfacePort' and/or 'proxyPort'. Add these values to properties file: {}", (Object)"bidib-spy.yml");
            return false;
        }
        return true;
    }
}

