/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.spy.preferences.controller;

import java.awt.Frame;
import org.apache.commons.configuration2.Configuration;
import org.bidib.wizard.spy.BidibSpyConfig;
import org.bidib.wizard.spy.preferences.controller.PreferencesController;
import org.bidib.wizard.spy.preferences.model.PreferencesModel;
import org.bidib.wizard.spy.preferences.view.PreferencesView;
import org.bidib.wizard.spy.preferences.view.listener.PreferencesViewListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesController.class);
    private final Frame parent;

    public PreferencesController(Frame parent) {
        this.parent = parent;
    }

    public void start(BidibSpyConfig config) {
        LOGGER.debug("Start the preferences controller.");
        PreferencesModel model = this.createFromConfig(config);
        1 listener = new /* Unavailable Anonymous Inner Class!! */;
        PreferencesView view = new PreferencesView(this.parent, model, (PreferencesViewListener)listener);
        LOGGER.info("After show view: {}", (Object)view);
    }

    protected PreferencesModel createFromConfig(BidibSpyConfig config) {
        PreferencesModel preferencesModel = new PreferencesModel();
        String interfacePort = config.getConfig().getString("spy.interfacePort");
        String proxyPort = config.getConfig().getString("spy.proxyPort");
        String serialPortProvider = config.getConfig().getString("spy.serialPortProvider");
        preferencesModel.setInterfacePort(interfacePort);
        preferencesModel.setProxyPort(proxyPort);
        preferencesModel.setSerialPortProvider(serialPortProvider);
        return preferencesModel;
    }

    protected void updateConfig(BidibSpyConfig spyConfig, String configName, PreferencesModel preferencesModel) {
        Configuration conf = spyConfig.getConfig().getConfiguration(configName);
        conf.setProperty("spy.interfacePort", (Object)preferencesModel.getInterfacePort());
        conf.setProperty("spy.proxyPort", (Object)preferencesModel.getProxyPort());
        conf.setProperty("spy.serialPortProvider", (Object)preferencesModel.getSerialPortProvider());
    }
}

