package org.bidib.wizard.tracer.client.model;

import javax.swing.SwingUtilities;

import org.bidib.wizard.common.model.settings.TracerServiceSettingsInterface;

import com.jgoodies.binding.beans.Model;

public class TracerClientModel extends Model {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_CONNECTED = "connected";

    public static final String PROPERTY_DISCONNECTED = "disconnected";

    public static final String PROPERTY_LOG_TO_FILE = "logToFile";

    public static final String PROPERTY_LOGFILE_NAME = "logFileName";

    private boolean connected;

    // private boolean logToFile;
    //
    // private String logFileName;

    private final TracerServiceSettingsInterface tracerServiceSettings;

    public TracerClientModel(final TracerServiceSettingsInterface tracerServiceSettings) {
        this.tracerServiceSettings = tracerServiceSettings;
    }

    /**
     * @return the connected
     */
    public boolean isConnected() {
        return connected;
    }

    /**
     * @param connected
     *            the connected to set
     */
    public void setConnected(boolean connected) {
        boolean oldValue = this.connected;
        this.connected = connected;

        if (SwingUtilities.isEventDispatchThread()) {
            firePropertyChange(PROPERTY_CONNECTED, oldValue, connected);
            firePropertyChange(PROPERTY_DISCONNECTED, !oldValue, !connected);
        }
        else {
            SwingUtilities.invokeLater(() -> {
                firePropertyChange(PROPERTY_CONNECTED, oldValue, connected);
                firePropertyChange(PROPERTY_DISCONNECTED, !oldValue, !connected);
            });
        }
    }

    /**
     * @return the disconnected state
     */
    public boolean isDisconnected() {
        return !connected;
    }

    /**
     * @param disconnected
     *            the connected to set
     */
    public void setDisconnected(boolean disconnected) {
        setConnected(!disconnected);
    }

    /**
     * @return the logToFile
     */
    public boolean isLogToFile() {
        return this.tracerServiceSettings.isLogToFile();
    }

    /**
     * @param logToFile
     *            the logToFile to set
     */
    public void setLogToFile(boolean logToFile) {
        boolean oldValue = this.tracerServiceSettings.isLogToFile();
        this.tracerServiceSettings.setLogToFile(logToFile);
        firePropertyChange(PROPERTY_LOG_TO_FILE, oldValue, logToFile);
    }

    /**
     * @return the logFileName
     */
    public String getLogFileName() {
        return this.tracerServiceSettings.getLogFileName();
    }

    /**
     * @param logFileName
     *            the logFileName to set
     */
    public void setLogFileName(String logFileName) {
        String oldValue = this.tracerServiceSettings.getLogFileName();
        this.tracerServiceSettings.setLogFileName(logFileName);
        firePropertyChange(PROPERTY_LOGFILE_NAME, oldValue, logFileName);
    }
}
