/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.tracer.client.controller;

import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingConstants;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.DockingUtilities;
import com.vlsolutions.swing.docking.RelativeDockablePosition;
import com.vlsolutions.swing.docking.TabbedDockableContainer;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import javax.swing.SwingUtilities;
import org.bidib.jbidibc.messages.base.BidibPortStatusListener;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.client.common.view.DockUtils;
import org.bidib.wizard.common.model.settings.TracerServiceSettingsInterface;
import org.bidib.wizard.tracer.client.controller.listener.TracerClientControllerListener;
import org.bidib.wizard.tracer.client.model.TracerClientModel;
import org.bidib.wizard.tracer.client.view.TracerClientView;
import org.bidib.wizard.tracer.client.view.listener.TracerClientViewListener;
import org.bidib.wizard.tracer.event.TracerMessageEvent;
import org.bidib.wizard.tracer.service.BidibTracerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracerClientController
implements TracerClientControllerListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(TracerClientController.class);
    private final DockingDesktop desktop;
    private TracerClientView tracerClientView;
    private TracerClientModel tracerClientModel;
    private final TracerServiceSettingsInterface tracerServiceSettings;
    private final BidibTracerService bidibTracerService;
    private BidibPortStatusListener bidibPortStatusListener;
    private CompositeDisposable compositeDisposable;

    public TracerClientController(DockingDesktop desktop, TracerServiceSettingsInterface tracerServiceSettings, BidibTracerService bidibTracerService) {
        this.desktop = desktop;
        this.tracerServiceSettings = tracerServiceSettings;
        this.bidibTracerService = bidibTracerService;
    }

    public void start() {
        String searchKey = "TracerClientView";
        LOGGER.info("Search for view with key: {}", (Object)searchKey);
        Dockable view = this.desktop.getContext().getDockableByKey(searchKey);
        if (view != null) {
            LOGGER.info("Select the existing tracer client view instead of open a new one.");
            DockUtils.selectWindow((Dockable)view);
            return;
        }
        LOGGER.info("Create new TracerClientView.");
        this.tracerClientModel = new TracerClientModel(this.tracerServiceSettings);
        this.tracerClientView = new TracerClientView(this.desktop, this, this.tracerClientModel);
        this.tracerClientView.initComponents();
        DockableState[] dockables = this.desktop.getDockables();
        LOGGER.info("Current dockables: {}", new Object[]{dockables});
        if (dockables.length > 1) {
            DockableState tabPanelNodeDetails = null;
            for (DockableState dockable : dockables) {
                if (!DockKeys.DOCKKEY_TAB_PANEL.equals((Object)dockable.getDockable().getDockKey())) continue;
                LOGGER.info("Found the tab panel dockable.");
                tabPanelNodeDetails = dockable;
                break;
            }
            Dockable dock = this.desktop.getDockables()[1].getDockable();
            if (tabPanelNodeDetails != null) {
                LOGGER.info("Add the tracerClientView next to the node details panel.");
                dock = tabPanelNodeDetails.getDockable();
                TabbedDockableContainer container = DockingUtilities.findTabbedDockableContainer((Dockable)dock);
                int order = 0;
                if (container != null) {
                    order = container.getTabCount();
                }
                LOGGER.info("Add new tracerClientView at order: {}", (Object)order);
                this.desktop.createTab(dock, (Dockable)this.tracerClientView, order, true);
            } else {
                this.desktop.split(dock, (Dockable)this.tracerClientView, DockingConstants.SPLIT_RIGHT);
            }
        } else {
            this.desktop.addDockable((Dockable)this.tracerClientView, RelativeDockablePosition.RIGHT);
        }
        this.tracerClientView.addTracerClientViewListener(new TracerClientViewListener(){

            @Override
            public void openConnection() {
                TracerClientController.this.openConnection();
            }

            @Override
            public void closeConnection() {
                TracerClientController.this.closeConnection();
            }
        });
    }

    @Override
    public void viewClosed() {
        LOGGER.info("The tracer view was closed. Close the connection.");
        this.closeConnection();
    }

    private void openConnection() {
        LOGGER.info("Open the tracer connections. Current tracerServiceSettings: {}", (Object)this.tracerServiceSettings);
        this.compositeDisposable = new CompositeDisposable();
        Disposable dispMessageEvents = this.bidibTracerService.subscribeMessageEvents(me -> this.publishTracerMessage((TracerMessageEvent)me), error -> LOGGER.warn("The message events subject signalled an error: {}", error), () -> LOGGER.warn("The timeEvents have completed for tracer service."));
        this.compositeDisposable.add(dispMessageEvents);
        this.bidibPortStatusListener = new BidibPortStatusListener(){

            public void statusChanged(String connectionId, BidibPortStatusListener.PortStatus portStatus) {
                LOGGER.info("The status of the tracer connection has changed, connectionId: {}, portStatus: {}", (Object)connectionId, (Object)portStatus);
                TracerClientController.this.tracerClientModel.setConnected(BidibPortStatusListener.PortStatus.CONNECTED == portStatus);
            }
        };
        this.bidibTracerService.start(this.bidibPortStatusListener);
    }

    private void publishTracerMessage(@NonNull TracerMessageEvent me) {
        LOGGER.info("Received tracer message event: {}", (Object)me);
        SwingUtilities.invokeLater(() -> this.tracerClientView.addLog(me));
    }

    private void closeConnection() {
        LOGGER.info("Close the tracer connections.");
        this.bidibTracerService.shutdown();
        LOGGER.info("Dispose the subscription.");
        this.compositeDisposable.dispose();
        this.compositeDisposable.clear();
        this.compositeDisposable = null;
    }
}

