package org.bidib.wizard.tracer.client.preferences.view.panel;

import javax.swing.ListModel;

import org.bidib.api.json.types.SerialPortInfo;

import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.common.collect.ArrayListModel;

public class SerialPortInfoConverter implements BindingConverter<String, SerialPortInfo> {

    private final ListModel<SerialPortInfo> commPorts;

    public SerialPortInfoConverter(final ArrayListModel<SerialPortInfo> commPorts) {
        this.commPorts = new ArrayListModel<>(commPorts);
    }

    @Override
    public String sourceValue(SerialPortInfo sourceValue) {
        if (sourceValue != null) {
            return sourceValue.getPortName();
        }
        return null;
    }

    @Override
    public SerialPortInfo targetValue(String targetValue) {

        for (int index = 0; index < commPorts.getSize(); index++) {
            SerialPortInfo info = commPorts.getElementAt(index);
            if (info.getPortName().equalsIgnoreCase(targetValue)) {
                return info;
            }
        }

        return null;
    }
}
