/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.tracer.client.preferences.view.panel;

import com.jgoodies.binding.adapter.ComboBoxAdapter;
import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.BufferedValueModel;
import com.jgoodies.binding.value.ConverterValueModel;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.common.collect.ArrayListModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.function.Consumer;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.border.Border;
import org.apache.commons.lang3.StringUtils;
import org.bidib.api.json.types.SerialPortInfo;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.preferences.view.panel.AbstractSettingsPanel;
import org.bidib.wizard.client.common.preferences.view.panel.SettingsPanelInterface;
import org.bidib.wizard.common.model.settings.TracerServiceSettingsInterface;
import org.bidib.wizard.core.service.SystemInfoService;
import org.bidib.wizard.tracer.client.preferences.view.panel.SerialPortInfoConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracerServiceSettingsPanel
extends AbstractSettingsPanel<TracerServiceSettingsInterface>
implements SettingsPanelInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(TracerServiceSettingsPanel.class);
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, fill:50dlu:grow, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref";
    private final TracerServiceSettingsInterface tracerServiceSettings;
    private final SystemInfoService systemInfoService;
    private JPanel contentPanel;

    public TracerServiceSettingsPanel(TracerServiceSettingsInterface tracerServiceSettings, SystemInfoService systemInfoService) {
        super(null);
        this.tracerServiceSettings = tracerServiceSettings;
        this.systemInfoService = systemInfoService;
    }

    public JPanel createPanel(Consumer<Boolean> bufferingCallback) {
        this.setBufferingCallback(bufferingCallback);
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.TABBED_DIALOG);
        this.preparePresentationModel(this.tracerServiceSettings);
        ArrayListModel serialProviderList = new ArrayListModel();
        serialProviderList.add((Object)"RXTX");
        serialProviderList.add((Object)"SCM");
        serialProviderList.add((Object)"SPSW");
        serialProviderList.add((Object)"JSerialComm");
        serialProviderList.add((Object)"PureJavaComm");
        BufferedValueModel selectionHolderSerialProvider = this.presentationModel.getBufferedModel("serialPortProvider");
        SelectionInList serialProviderSelection = new SelectionInList((ListModel)serialProviderList);
        ComboBoxAdapter comboBoxAdapterSerialProvider = new ComboBoxAdapter((ListModel)serialProviderSelection, (ValueModel)selectionHolderSerialProvider);
        JComboBox comboSerialProvider = new JComboBox();
        comboSerialProvider.setModel(comboBoxAdapterSerialProvider);
        dialogBuilder.add(Resources.getString(TracerServiceSettingsPanel.class, (String)"serialPortProvider") + ":", new Object[0]).xy(1, 1);
        dialogBuilder.add(comboSerialProvider).xyw(3, 1, 5);
        BufferedValueModel bufferedDownstreamPortModel = this.presentationModel.getBufferedModel("downstreamPort");
        dialogBuilder.add(Resources.getString(TracerServiceSettingsPanel.class, (String)"downstreamPort") + ":", new Object[0]).xy(1, 3);
        ArrayListModel commPorts = new ArrayListModel();
        for (SerialPortInfo commPort : this.systemInfoService.getRegisteredSerialPorts()) {
            commPorts.add((Object)commPort);
        }
        SerialPortInfo commPortNone = new SerialPortInfo();
        commPortNone.setPortName("<none>");
        commPorts.add(0, (Object)commPortNone);
        LOGGER.info("Prepared serial ports to diplay in combobox: {}", (Object)commPorts);
        SelectionInList serialPortSelection = new SelectionInList((ListModel)commPorts);
        SerialPortInfoConverter converter = new SerialPortInfoConverter((ArrayListModel<SerialPortInfo>)commPorts);
        ConverterValueModel downstreamPortConverterModel = new ConverterValueModel((ValueModel)bufferedDownstreamPortModel, (BindingConverter)converter);
        ComboBoxAdapter comboBoxAdapterSerialPortDownstream = new ComboBoxAdapter((ListModel)serialPortSelection, (ValueModel)downstreamPortConverterModel);
        JComboBox<Object> commPortsComboDownstream = new JComboBox<Object>();
        commPortsComboDownstream.setModel((ComboBoxModel<Object>)comboBoxAdapterSerialPortDownstream);
        commPortsComboDownstream.setRenderer(new SerialPortInfoListRenderer());
        dialogBuilder.add(commPortsComboDownstream).xyw(3, 3, 5);
        BufferedValueModel bufferedUpstreamPortModel = this.presentationModel.getBufferedModel("upstreamPort");
        dialogBuilder.add(Resources.getString(TracerServiceSettingsPanel.class, (String)"upstreamPort") + ":", new Object[0]).xy(1, 5);
        ConverterValueModel upstreamPortConverterModel = new ConverterValueModel((ValueModel)bufferedUpstreamPortModel, (BindingConverter)converter);
        ComboBoxAdapter comboBoxAdapterSerialPortUpstream = new ComboBoxAdapter((ListModel)serialPortSelection, (ValueModel)upstreamPortConverterModel);
        JComboBox<Object> commPortsComboUpstream = new JComboBox<Object>();
        commPortsComboUpstream.setModel((ComboBoxModel<Object>)comboBoxAdapterSerialPortUpstream);
        commPortsComboUpstream.setRenderer(new SerialPortInfoListRenderer());
        dialogBuilder.add(commPortsComboUpstream).xyw(3, 5, 5);
        this.contentPanel = dialogBuilder.build();
        this.contentPanel.setOpaque(false);
        return this.contentPanel;
    }

    public String getTabTitle() {
        return Resources.getString(((Object)((Object)this)).getClass(), (String)"tab-tracer-service.title");
    }

    public String getTabTooltip() {
        return Resources.getString(((Object)((Object)this)).getClass(), (String)"tab-tracer-service.tooltip");
    }

    private static final class SerialPortInfoListRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private SerialPortInfoListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof SerialPortInfo) {
                SerialPortInfo serialPortInfo = (SerialPortInfo)value;
                if (serialPortInfo.getPortName() != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(serialPortInfo.getPortName());
                    if (StringUtils.isNotBlank((CharSequence)serialPortInfo.getProductString())) {
                        sb.append(" - ").append(serialPortInfo.getProductString());
                    }
                    if (StringUtils.isNotBlank((CharSequence)serialPortInfo.getSerialNumber())) {
                        sb.append(" - ").append(serialPortInfo.getSerialNumber());
                    }
                    this.setText(sb.toString());
                } else {
                    this.setText(serialPortInfo.getPortName());
                }
            } else {
                this.setText(" ");
            }
            return comp;
        }
    }
}

