/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.tracer.client.view;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.beans.PropertyConnector;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.debug.FormDebugPanel;
import com.jgoodies.forms.factories.Paddings;
import com.jidesoft.swing.JideScrollPane;
import com.vlsolutions.swing.docking.DockKey;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.event.DockableStateChangeEvent;
import com.vlsolutions.swing.docking.event.DockableStateChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.bidib.wizard.api.locale.Resources;
import org.bidib.wizard.client.common.text.WizardComponentFactory;
import org.bidib.wizard.client.common.view.DockKeys;
import org.bidib.wizard.core.dialog.FileDialog;
import org.bidib.wizard.tracer.client.controller.listener.TracerClientControllerListener;
import org.bidib.wizard.tracer.client.model.TracerClientModel;
import org.bidib.wizard.tracer.client.view.listener.TracerClientViewListener;
import org.bidib.wizard.tracer.event.TracerMessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracerClientView
implements Dockable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TracerClientView.class);
    private static final String TRACER_CLIENT = "TracerClient";
    private static final Logger LOGGER_TRACER_CLIENT = LoggerFactory.getLogger((String)"TracerClient");
    private static final String ENCODED_DIALOG_COLUMN_SPECS = "pref, 3dlu, pref, 3dlu, pref, 3dlu, fill:pref:grow, 3dlu, pref, 3dlu, pref";
    private static final String ENCODED_DIALOG_ROW_SPECS = "pref, 3dlu, fill:50dlu:grow";
    private JComponent contentPanel;
    private final DockingDesktop desktop;
    private final TracerClientModel tracerClientModel;
    private final DockableStateChangeListener dockableStateChangeListener;
    private final Collection<TracerClientViewListener> listeners = new LinkedList<TracerClientViewListener>();
    private final JButton connectButton = new JButton(Resources.getString(TracerClientView.class, (String)"connect"));
    private final JButton disconnectButton = new JButton(Resources.getString(TracerClientView.class, (String)"disconnect"));
    private final JTextArea logsArea = new JTextArea();
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    private StringBuilder sbLogger = new StringBuilder();
    private JCheckBox logToFile;
    private ValueModel selectedLogFileValueModel;
    private final JButton selectLogFileButton = new JButton(Resources.getString(TracerClientView.class, (String)"select-logfile"));
    private static final String SUFFIX_LOG = "log";
    private static final String SUFFIX_TXT = "txt";
    private final FileFilter ffLogFile = new FileFilter(){

        @Override
        public boolean accept(File file) {
            boolean result = false;
            if (file != null) {
                if (file.isDirectory()) {
                    result = true;
                } else if (FilenameUtils.wildcardMatch((String)file.getName(), (String)"*.log")) {
                    result = true;
                } else if (FilenameUtils.wildcardMatch((String)file.getName(), (String)"*.txt")) {
                    result = true;
                }
            }
            return result;
        }

        @Override
        public String getDescription() {
            return Resources.getString(TracerClientView.class, (String)"filterLogFile") + " (*.log,*.txt)";
        }
    };
    private FileAppender<ILoggingEvent> fileAppender;

    public TracerClientView(final DockingDesktop desktop, final TracerClientControllerListener listener, TracerClientModel tracerClientModel) {
        this.desktop = desktop;
        this.tracerClientModel = tracerClientModel;
        DockKeys.DOCKKEY_TRACER_CLIENT_VIEW.setName(Resources.getString(TracerClientView.class, (String)"title"));
        DockKeys.DOCKKEY_TRACER_CLIENT_VIEW.setFloatEnabled(true);
        DockKeys.DOCKKEY_TRACER_CLIENT_VIEW.setAutoHideEnabled(false);
        this.dockableStateChangeListener = new DockableStateChangeListener(){

            public void dockableStateChanged(DockableStateChangeEvent event) {
                LOGGER.info("The state has changed, newState: {}, prevState: {}", (Object)event.getNewState(), (Object)event.getPreviousState());
                DockableState newState = event.getNewState();
                if (newState.getDockable().equals((Object)TracerClientView.this) && newState.isClosed()) {
                    LOGGER.info("The NodesClientView is closed.");
                    desktop.removeDockableStateChangeListener(TracerClientView.this.dockableStateChangeListener);
                    if (listener != null) {
                        LOGGER.info("Close the view.");
                        listener.viewClosed();
                    }
                }
            }
        };
        desktop.addDockableStateChangeListener(this.dockableStateChangeListener);
    }

    public JComponent initComponents() {
        FormBuilder dialogBuilder = null;
        boolean debugDialog = false;
        if (debugDialog) {
            panel = new FormDebugPanel();
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        } else {
            panel = new JPanel(new BorderLayout());
            dialogBuilder = FormBuilder.create().columns(ENCODED_DIALOG_COLUMN_SPECS, new Object[0]).rows(ENCODED_DIALOG_ROW_SPECS, new Object[0]).panel((JPanel)panel);
        }
        dialogBuilder.border((Border)Paddings.DIALOG);
        this.connectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TracerClientView.this.fireConnect();
            }
        });
        this.disconnectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TracerClientView.this.fireDisconnect();
            }
        });
        this.disconnectButton.setEnabled(false);
        dialogBuilder.add((Component)this.connectButton).xy(1, 1);
        dialogBuilder.add((Component)this.disconnectButton).xy(3, 1);
        this.logToFile = new JCheckBox(Resources.getString(this.getClass(), (String)"logToFile"));
        dialogBuilder.add((Component)this.logToFile).xy(5, 1);
        this.selectedLogFileValueModel = new PropertyAdapter((Object)this.tracerClientModel, "logFileName", true);
        JTextField selectedLogFileText = WizardComponentFactory.createTextField((ValueModel)this.selectedLogFileValueModel, (boolean)true);
        selectedLogFileText.setEditable(false);
        dialogBuilder.add((Component)selectedLogFileText).xyw(7, 1, 3);
        this.selectLogFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TracerClientView.this.selectLogFile();
            }
        });
        dialogBuilder.add((Component)this.selectLogFileButton).xy(11, 1);
        this.logsArea.setEditable(false);
        this.logsArea.setFont(new Font("Monospaced", 0, 13));
        JScrollPane logsPane = new JScrollPane(this.logsArea);
        logsPane.setAutoscrolls(true);
        dialogBuilder.add((Component)logsPane).xyw(1, 3, 11);
        JPanel contentPanelTemp = dialogBuilder.build();
        JideScrollPane scrollPane = new JideScrollPane((Component)contentPanelTemp);
        this.contentPanel = scrollPane;
        PropertyConnector.connect((Object)((Object)this.tracerClientModel), (String)"disconnected", (Object)this.connectButton, (String)"enabled");
        PropertyConnector.connect((Object)((Object)this.tracerClientModel), (String)"connected", (Object)this.disconnectButton, (String)"enabled");
        this.logToFile.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean logToFileEnabled = e.getStateChange() == 1;
                TracerClientView.this.tracerClientModel.setLogToFile(logToFileEnabled);
                if (logToFileEnabled) {
                    TracerClientView.this.activateLogger(TracerClientView.this.tracerClientModel.getLogFileName());
                } else {
                    TracerClientView.this.deactivateLogger();
                }
            }
        });
        return this.contentPanel;
    }

    public DockKey getDockKey() {
        return DockKeys.DOCKKEY_TRACER_CLIENT_VIEW;
    }

    public Component getComponent() {
        return this.contentPanel;
    }

    public void addTracerClientViewListener(TracerClientViewListener l) {
        this.listeners.add(l);
    }

    private void fireConnect() {
        for (TracerClientViewListener listener : this.listeners) {
            listener.openConnection();
        }
    }

    private void fireDisconnect() {
        for (TracerClientViewListener listener : this.listeners) {
            listener.closeConnection();
        }
    }

    public void addLog(TracerMessageEvent me) {
        try {
            LOGGER_TRACER_CLIENT.info(me.getMessage());
            this.sbLogger.append(this.formatter.format(me.getTimestamp()));
            this.sbLogger.append(" - ");
            this.sbLogger.append(me.getMessage());
            this.addLogMessage(this.sbLogger.toString());
        }
        catch (Exception ex) {
            LOGGER.warn("Add message to logsArea failed.", (Throwable)ex);
        }
        finally {
            this.sbLogger.setLength(0);
        }
    }

    private void addLogMessage(String logMessage) {
        try {
            int lines = this.logsArea.getLineCount();
            if (lines > 500) {
                int end = this.logsArea.getLineEndOffset(50);
                this.logsArea.getDocument().remove(0, end);
            }
            this.logsArea.append(logMessage);
            this.logsArea.append("\n");
        }
        catch (BadLocationException ex) {
            LOGGER.warn("Remove some lines from logsArea failed.", (Throwable)ex);
        }
    }

    private void selectLogFile() {
        String storedWorkingDirectory = null;
        try {
            storedWorkingDirectory = this.tracerClientModel.getLogFileName() != null ? FileUtils.getFile((String[])new String[]{this.tracerClientModel.getLogFileName()}).getParent() : null;
        }
        catch (Exception ex) {
            LOGGER.warn("Get the storedWorkingDirectory from settings failed.", (Throwable)ex);
        }
        FileDialog dialog = new FileDialog(this.contentPanel, 1, storedWorkingDirectory, null, new FileFilter[]{this.ffLogFile}){

            public void approve(String selectedFile) {
                File file = new File(selectedFile);
                selectedFile = file.getName();
                TracerClientView.this.tracerClientModel.setLogFileName(file.toString());
            }
        };
        dialog.showDialog();
    }

    protected void activateLogger(String logFile) {
        if (this.fileAppender != null && this.fileAppender.isStarted()) {
            LOGGER.warn("The file appender for the tracer log is assigned and started already.");
            return;
        }
        if (this.fileAppender == null) {
            LOGGER.info("Create the appender for the tracer log.");
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            PatternLayoutEncoder ple = new PatternLayoutEncoder();
            ple.setPattern("%date %level [%thread] %logger{10} [%file:%line] %msg%n");
            ple.setContext((Context)lc);
            ple.start();
            this.fileAppender = new FileAppender();
            this.fileAppender.setFile(logFile);
            this.fileAppender.setEncoder((Encoder)ple);
            this.fileAppender.setContext((Context)lc);
        }
        LOGGER.info("Start the appender for the tracer log.");
        this.fileAppender.start();
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)TRACER_CLIENT);
        logbackLogger.addAppender(this.fileAppender);
        logbackLogger.setLevel(Level.DEBUG);
        logbackLogger.setAdditive(false);
    }

    protected void deactivateLogger() {
        if (this.fileAppender == null) {
            LOGGER.warn("The file appender for the tracer log is not assigned.");
            return;
        }
        LOGGER.info("Stop the appender for the tracer log.");
        ch.qos.logback.classic.Logger logbackLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)TRACER_CLIENT);
        logbackLogger.detachAppender(this.fileAppender);
        this.fileAppender.stop();
    }
}

