package org.bidib.wizard.tracer.service;

import org.bidib.jbidibc.messages.base.BidibPortStatusListener;
import org.bidib.wizard.tracer.event.TracerMessageEvent;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;

public interface BidibTracerService {

    /**
     * Subscribe to tracer message events.
     * 
     * @param onNext
     *            the data handler
     * @param onError
     *            the error handler
     * @param onComplete
     *            the complete action
     * @return the disposable
     */
    Disposable subscribeMessageEvents(
        Consumer<TracerMessageEvent> onNext, Consumer<Throwable> onError, Action onComplete);

    /**
     * Start the bidib tracer service.
     * 
     * @param bidibPortStatusListener
     *            the port status listener
     */
    void start(final BidibPortStatusListener bidibPortStatusListener);

    /**
     * Shutdown the bidib tracer service.
     */
    void shutdown();

}
