package org.bidib.wizard.tracer.autoconfig;

import org.bidib.wizard.common.model.settings.TracerServiceSettingsInterface;
import org.bidib.wizard.tracer.config.TracerServiceSettings;
import org.bidib.wizard.tracer.service.BidibTracerService;
import org.bidib.wizard.tracer.service.DefaultBidibTracerService;
import org.springframework.boot.autoconfigure.AutoConfigurationPackage;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigurationPackage
@EnableConfigurationProperties(TracerServiceSettings.class)
public class TracerAutoConfig {

    @Bean
    BidibTracerService bidibTracerService(final TracerServiceSettingsInterface tracerServiceSettings) {
        final BidibTracerService bidibTracerService = new DefaultBidibTracerService(tracerServiceSettings);
        return bidibTracerService;
    }

    // @ConditionalOnMissingBean
    // @Bean
    // BidibRequestFactory requestFactory() {
    // final BidibRequestFactory requestFactory = new BidibRequestFactory();
    // requestFactory.initialize();
    // return requestFactory;
    // }

}
