/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.tracer.service;

import java.io.ByteArrayOutputStream;
import java.util.List;
import org.bidib.jbidibc.messages.MessageProcessor;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownstreamTracerMessageProcessor
implements MessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DownstreamTracerMessageProcessor.class);
    private final org.bidib.jbidibc.messages.logger.Logger messageLogger;
    private boolean checkCRC;
    private final BidibRequestFactory requestFactory;
    private boolean isFirstPacket = true;
    private final org.bidib.jbidibc.messages.logger.Logger splitMessageLogger;

    public DownstreamTracerMessageProcessor(org.bidib.jbidibc.messages.logger.Logger messageLogger, boolean checkCRC) {
        this.messageLogger = messageLogger;
        this.requestFactory = new BidibRequestFactory();
        this.requestFactory.initialize();
        this.checkCRC = checkCRC;
        this.splitMessageLogger = new org.bidib.jbidibc.messages.logger.Logger(){

            public void debug(String format, Object ... arguments) {
                LOGGER.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                LOGGER.info(format, arguments);
            }

            public void warn(String format, Object ... arguments) {
                LOGGER.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                LOGGER.error(format, arguments);
            }
        };
        LOGGER.info("Create new ProxyMessageProcessor with checkCRC: {}", (Object)checkCRC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processMessages(ByteArrayOutputStream messageData) throws ProtocolException {
        if (messageData.size() < 1) {
            LOGGER.info("No data in provided buffer, skip process messages.");
            return;
        }
        messageData.write(ByteUtils.getLowByte((int)254));
        LOGGER.info("Process messages, current messageData: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)messageData));
        List bidibMessages = null;
        try {
            bidibMessages = this.requestFactory.create(messageData.toByteArray());
            for (BidibMessageInterface message : bidibMessages) {
                LOGGER.info("Current bidibMessages: {}", (Object)bidibMessages);
                StringBuilder sb = new StringBuilder(">> ");
                sb.append(bidibMessages);
                sb.append(" : ");
                sb.append(ByteUtils.bytesToHex((byte[])message.getContent()));
                this.messageLogger.info(sb.toString(), new Object[0]);
            }
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)messageData), (Object)ex);
            StringBuilder sb = new StringBuilder(">> received invalid: ");
            sb.append(bidibMessages);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])messageData.toByteArray()));
            this.messageLogger.warn(sb.toString(), new Object[0]);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)messageData), (Object)ex);
        }
        finally {
            messageData.reset();
        }
    }
}

