/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.tracer.service;

import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.schedulers.Schedulers;
import io.reactivex.rxjava3.subjects.PublishSubject;
import java.io.ByteArrayOutputStream;
import java.time.LocalDateTime;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.bidib.jbidibc.debug.DebugInterface;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.debug.DebugMessageReceiver;
import org.bidib.jbidibc.debug.DebugReaderFactory;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.MessageProcessor;
import org.bidib.jbidibc.messages.base.BidibPortStatusListener;
import org.bidib.jbidibc.messages.exception.PortNotFoundException;
import org.bidib.jbidibc.messages.exception.PortNotOpenedException;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.helpers.DefaultContext;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.serial.SerialMessageParser;
import org.bidib.wizard.common.model.settings.TracerServiceSettingsInterface;
import org.bidib.wizard.tracer.event.TracerMessageEvent;
import org.bidib.wizard.tracer.service.BidibTracerService;
import org.bidib.wizard.tracer.service.DownstreamTracerMessageProcessor;
import org.bidib.wizard.tracer.service.UpstreamTracerMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class DefaultBidibTracerService
implements BidibTracerService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBidibTracerService.class);
    public static final String VALID_HOSTNAME_REGEX = "^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$";
    private final TracerServiceSettingsInterface tracerServiceSettings;
    private ConnectionListener upstreamConnectionListener;
    private ConnectionListener downstreamConnectionListener;
    private DebugInterface upstreamPort;
    private DebugInterface downstreamPort;
    private UpstreamTracerMessageProcessor upstreamTracerMessageProcessor;
    private DownstreamTracerMessageProcessor downstreamTracerMessageProcessor;
    private PublishSubject<TracerMessageEvent> subjectMessageEvents;

    public DefaultBidibTracerService(TracerServiceSettingsInterface tracerServiceSettings) {
        LOGGER.info("Create new instance of DefaultBidibTracerService.");
        this.tracerServiceSettings = tracerServiceSettings;
        this.subjectMessageEvents = PublishSubject.create();
    }

    @Override
    public Disposable subscribeMessageEvents(Consumer<TracerMessageEvent> onNext, Consumer<Throwable> onError, Action onComplete) {
        LOGGER.info("Subscribe to tracer message events.");
        return this.subjectMessageEvents.observeOn(Schedulers.computation()).subscribe(onNext, onError, onComplete);
    }

    @Override
    public void start(final BidibPortStatusListener bidibPortStatusListener) {
        DefaultContext context = new DefaultContext();
        String upstreamPortName = this.tracerServiceSettings.getUpstreamPort();
        String downstreamPortName = this.tracerServiceSettings.getDownstreamPort();
        String serialPortProvider = this.tracerServiceSettings.getSerialPortProvider();
        LOGGER.info("Configured serialPortProvider: {}, upstreamPortName: {}, downstreamPortName: {}", new Object[]{serialPortProvider, upstreamPortName, downstreamPortName});
        DebugReaderFactory.SerialImpl serialImpl = DebugReaderFactory.SerialImpl.SCM;
        if (StringUtils.isNotBlank((CharSequence)serialPortProvider)) {
            switch (serialPortProvider) {
                case "RXTX": {
                    serialImpl = DebugReaderFactory.SerialImpl.RXTX;
                    LOGGER.info("Set the system property: gnu.io.rxtx.SerialPorts, value: {}", (Object)(downstreamPortName + ":" + upstreamPortName));
                    break;
                }
                case "PUREJAVACOMM": {
                    serialImpl = DebugReaderFactory.SerialImpl.PUREJAVACOMM;
                    break;
                }
            }
        }
        LOGGER.info("Use the serial port provider impl: {}", (Object)serialImpl);
        this.upstreamConnectionListener = new ConnectionListener(){

            public void status(String messageKey, Context context) {
                LOGGER.info("The status of the upstream port has changed: {}, context: {}", (Object)messageKey, (Object)context);
            }

            public void opened(String port) {
                LOGGER.info("The upstream port was opened: {}", (Object)port);
                bidibPortStatusListener.statusChanged("upstream", BidibPortStatusListener.PortStatus.CONNECTED);
            }

            public void closed(String port) {
                LOGGER.info("The interface port was closed: {}", (Object)port);
                bidibPortStatusListener.statusChanged("upstream", BidibPortStatusListener.PortStatus.DISCONNECTED);
            }

            public void stall(boolean stall) {
            }
        };
        this.downstreamConnectionListener = new ConnectionListener(){

            public void status(String messageKey, Context context) {
                LOGGER.info("The status of the downstream port has changed: {}, context: {}", (Object)messageKey, (Object)context);
            }

            public void opened(String port) {
                LOGGER.info("The downstream port was opened: {}", (Object)port);
                bidibPortStatusListener.statusChanged("downstream", BidibPortStatusListener.PortStatus.CONNECTED);
            }

            public void closed(String port) {
                LOGGER.info("The downstream port was closed: {}", (Object)port);
                bidibPortStatusListener.statusChanged("downstream", BidibPortStatusListener.PortStatus.DISCONNECTED);
            }

            public void stall(boolean stall) {
            }
        };
        this.openUpstreamPort((Context)context, upstreamPortName, serialImpl);
        this.openDownstreamPort((Context)context, downstreamPortName, serialImpl);
    }

    private void openUpstreamPort(Context context, String upstreamPortName, DebugReaderFactory.SerialImpl serialImpl) {
        LOGGER.info("Begin open the upstream port: {}", (Object)upstreamPortName);
        org.bidib.jbidibc.messages.logger.Logger messageLogger = new org.bidib.jbidibc.messages.logger.Logger(){

            public void debug(String format, Object ... arguments) {
                LOGGER.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                LOGGER.info(format, arguments);
                TracerMessageEvent event = new TracerMessageEvent("upstream", LocalDateTime.now(), MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
                DefaultBidibTracerService.this.subjectMessageEvents.onNext((Object)event);
            }

            public void warn(String format, Object ... arguments) {
                LOGGER.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                LOGGER.error(format, arguments);
            }
        };
        int baudRate = 115200;
        final SerialMessageParser upstreamMessageParser = new SerialMessageParser();
        this.upstreamTracerMessageProcessor = new UpstreamTracerMessageProcessor(messageLogger, true);
        DebugMessageReceiver messageReceiver = new DebugMessageReceiver(){

            public void processMessages(ByteArrayOutputStream output) {
                try {
                    LOGGER.info("<< Received data from interface: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
                    try {
                        upstreamMessageParser.parseInput((MessageProcessor)DefaultBidibTracerService.this.upstreamTracerMessageProcessor, output.toByteArray(), output.size());
                    }
                    catch (Exception ex1) {
                        LOGGER.warn("Prepare messages to send to proxy failed.", (Throwable)ex1);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Send message from interface to proxy failed.", (Throwable)ex);
                }
                finally {
                    output.reset();
                }
            }
        };
        if (upstreamPortName.contains(":")) {
            String[] splited = upstreamPortName.split(":");
            if (InetAddressValidator.getInstance().isValid(splited[0])) {
                LOGGER.info("Valid IP address detected: {}", (Object)splited[0]);
                serialImpl = DebugReaderFactory.SerialImpl.SPSW_NET;
            } else if (Pattern.matches(VALID_HOSTNAME_REGEX, splited[0])) {
                LOGGER.info("Valid hostname detected: {}", (Object)splited[0]);
                serialImpl = DebugReaderFactory.SerialImpl.SPSW_NET;
            }
        }
        try {
            this.upstreamPort = DebugReaderFactory.getDebugReader((DebugReaderFactory.SerialImpl)serialImpl, (DebugMessageProcessor)messageReceiver);
            this.upstreamPort.open(upstreamPortName, baudRate, this.upstreamConnectionListener, context);
            LOGGER.info("Open the upstream port passed.");
        }
        catch (PortNotFoundException ex) {
            LOGGER.warn("Selected upstream port is not available.", (Throwable)ex);
            throw new RuntimeException("Selected upstream port for is not available: " + ex.getMessage());
        }
        catch (PortNotOpenedException ex) {
            LOGGER.warn("Open upstream reader port failed.", (Throwable)ex);
            throw new RuntimeException("Open upstream reader port failed: " + ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.warn("Create upstream reader failed.", (Throwable)ex);
            throw new RuntimeException("Create upstream reader failed.");
        }
    }

    private void openDownstreamPort(Context context, String downstreamPortName, DebugReaderFactory.SerialImpl serialImpl) {
        LOGGER.info("Begin open the downstream port: {}", (Object)downstreamPortName);
        org.bidib.jbidibc.messages.logger.Logger messageLogger = new org.bidib.jbidibc.messages.logger.Logger(){

            public void debug(String format, Object ... arguments) {
                LOGGER.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                LOGGER.info(format, arguments);
                TracerMessageEvent event = new TracerMessageEvent("downstream", LocalDateTime.now(), MessageFormatter.arrayFormat((String)format, (Object[])arguments).getMessage());
                DefaultBidibTracerService.this.subjectMessageEvents.onNext((Object)event);
            }

            public void warn(String format, Object ... arguments) {
                LOGGER.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                LOGGER.error(format, arguments);
            }
        };
        int baudRate = 115200;
        final SerialMessageParser downstreamMessageParser = new SerialMessageParser();
        this.downstreamTracerMessageProcessor = new DownstreamTracerMessageProcessor(messageLogger, true);
        DebugMessageReceiver messageReceiver = new DebugMessageReceiver(){

            public void processMessages(ByteArrayOutputStream output) {
                try {
                    LOGGER.info("<< Received data from interface: {}", (Object)ByteUtils.bytesToHex((ByteArrayOutputStream)output));
                    try {
                        downstreamMessageParser.parseInput((MessageProcessor)DefaultBidibTracerService.this.downstreamTracerMessageProcessor, output.toByteArray(), output.size());
                    }
                    catch (Exception ex1) {
                        LOGGER.warn("Prepare messages to send to proxy failed.", (Throwable)ex1);
                    }
                }
                catch (Exception ex) {
                    LOGGER.warn("Send message from interface to proxy failed.", (Throwable)ex);
                }
                finally {
                    output.reset();
                }
            }
        };
        if (downstreamPortName.contains(":")) {
            String[] splited = downstreamPortName.split(":");
            if (InetAddressValidator.getInstance().isValid(splited[0])) {
                LOGGER.info("Valid IP address detected: {}", (Object)splited[0]);
                serialImpl = DebugReaderFactory.SerialImpl.SPSW_NET;
            } else if (Pattern.matches(VALID_HOSTNAME_REGEX, splited[0])) {
                LOGGER.info("Valid hostname detected: {}", (Object)splited[0]);
                serialImpl = DebugReaderFactory.SerialImpl.SPSW_NET;
            }
        }
        try {
            this.downstreamPort = DebugReaderFactory.getDebugReader((DebugReaderFactory.SerialImpl)serialImpl, (DebugMessageProcessor)messageReceiver);
            this.downstreamPort.open(downstreamPortName, baudRate, this.downstreamConnectionListener, context);
            LOGGER.info("Open the downstream port passed.");
        }
        catch (PortNotFoundException ex) {
            LOGGER.warn("Selected downstream port is not available.", (Throwable)ex);
            throw new RuntimeException("Selected downstream port for is not available: " + ex.getMessage());
        }
        catch (PortNotOpenedException ex) {
            LOGGER.warn("Open downstream reader port failed.", (Throwable)ex);
            throw new RuntimeException("Open downstream reader port failed: " + ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.warn("Create downstream reader failed.", (Throwable)ex);
            throw new RuntimeException("Create downstream reader failed.");
        }
    }

    @Override
    public void shutdown() {
        LOGGER.info("Shutdown the bidib tracer service.");
        this.closeUpstreamPort();
        this.closeDownstreamPort();
    }

    private void closeUpstreamPort() {
        LOGGER.info("Close the upstream port.");
        if (this.upstreamPort != null) {
            LOGGER.info("Close the upstream port: {}", (Object)this.upstreamPort);
            this.upstreamPort.close();
            this.upstreamPort = null;
        } else {
            LOGGER.info("No upstream port to close available.");
        }
    }

    private void closeDownstreamPort() {
        LOGGER.info("Close the downstream port.");
        if (this.downstreamPort != null) {
            LOGGER.info("Close the downstream port: {}", (Object)this.downstreamPort);
            this.downstreamPort.close();
            this.downstreamPort = null;
        } else {
            LOGGER.info("No downstream port to close available.");
        }
    }
}

