/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.tracer.service;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.messages.MessageProcessor;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibResponseFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpstreamTracerMessageProcessor
implements MessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpstreamTracerMessageProcessor.class);
    private final org.bidib.jbidibc.messages.logger.Logger messageLogger;
    private final boolean checkCRC;
    private final BidibResponseFactory responseFactory;
    private final AtomicBoolean isFirstPacket = new AtomicBoolean(true);
    private final org.bidib.jbidibc.messages.logger.Logger splitMessageLogger;

    public UpstreamTracerMessageProcessor(org.bidib.jbidibc.messages.logger.Logger messageLogger, boolean checkCRC) {
        this.messageLogger = messageLogger;
        this.responseFactory = new BidibResponseFactory();
        this.responseFactory.initialize();
        this.checkCRC = checkCRC;
        this.splitMessageLogger = new org.bidib.jbidibc.messages.logger.Logger(){

            public void debug(String format, Object ... arguments) {
                LOGGER.debug(format, arguments);
            }

            public void info(String format, Object ... arguments) {
                LOGGER.info(format, arguments);
            }

            public void warn(String format, Object ... arguments) {
                LOGGER.warn(format, arguments);
            }

            public void error(String format, Object ... arguments) {
                LOGGER.error(format, arguments);
            }
        };
        LOGGER.info("Create new ProxyMessageProcessor with checkCRC: {}", (Object)checkCRC);
    }

    public void processMessages(ByteArrayOutputStream messageData) throws ProtocolException {
        if (messageData.size() < 1) {
            LOGGER.info("No data in provided buffer, skip process messages.");
            return;
        }
        MessageUtils.splitBidibMessages((org.bidib.jbidibc.messages.logger.Logger)this.splitMessageLogger, (ByteArrayOutputStream)messageData, (boolean)this.checkCRC, (AtomicBoolean)this.isFirstPacket, messageArray -> this.processMessage(messageArray));
    }

    private void processMessage(byte[] messageArray) throws ProtocolException {
        this.isFirstPacket.set(false);
        BidibMessageInterface message = null;
        try {
            message = this.responseFactory.create(messageArray);
            StringBuilder sb = new StringBuilder("<< ");
            sb.append(message);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])messageArray));
            this.messageLogger.info(sb.toString(), new Object[0]);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray), (Object)ex);
            StringBuilder sb = new StringBuilder("<< received invalid: ");
            sb.append(message);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])messageArray));
            this.messageLogger.warn(sb.toString(), new Object[0]);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray), (Object)ex);
        }
    }
}

