package org.bidib.wizard.tracer.config;

import org.bidib.wizard.common.model.settings.AbstractSettings;
import org.bidib.wizard.common.model.settings.TracerServiceSettingsInterface;
import org.bidib.wizard.common.model.settings.annotation.SettingsIdentifier;
import org.bidib.wizard.common.model.settings.configuration.YamlPropertySourceFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix = "wizardmodule-tracer-configuration")
@SettingsIdentifier(storageIdentifier = "wizardmodule_tracerConfiguration")
@PropertySource(value = "file:${miscSettings.bidibConfigDir}/wizardmodule_tracerConfiguration.yml", factory = YamlPropertySourceFactory.class, ignoreResourceNotFound = true)
@Validated
public class TracerServiceSettings extends AbstractSettings implements TracerServiceSettingsInterface {

    private static final long serialVersionUID = 1L;

    private String upstreamPort;

    private String downstreamPort;

    private String serialPortProvider;

    private boolean logToFile;

    private String logFileName;

    /**
     * @return the upstreamPort
     */
    @Override
    public String getUpstreamPort() {
        return upstreamPort;
    }

    /**
     * @param upstreamPort
     *            the upstreamPort to set
     */
    @Override
    public void setUpstreamPort(String upstreamPort) {
        String oldValue = this.upstreamPort;
        this.upstreamPort = upstreamPort;

        firePropertyChange(PROPERTY_UPSTREAM_PORT, oldValue, this.upstreamPort);
    }

    /**
     * @return the downstreamPort
     */
    @Override
    public String getDownstreamPort() {
        return downstreamPort;
    }

    /**
     * @param downstreamPort
     *            the downstreamPort to set
     */
    @Override
    public void setDownstreamPort(String downstreamPort) {
        String oldValue = this.downstreamPort;
        this.downstreamPort = downstreamPort;

        firePropertyChange(PROPERTY_DOWNSTREAM_PORT, oldValue, this.downstreamPort);
    }

    @Override
    public String getSerialPortProvider() {
        return serialPortProvider;
    }

    @Override
    public void setSerialPortProvider(String serialPortProvider) {
        String oldValue = this.serialPortProvider;
        this.serialPortProvider = serialPortProvider;

        firePropertyChange(PROPERTY_SERIALPORT_PROVIDER, oldValue, this.serialPortProvider);
    }

    /**
     * @return the logToFile
     */
    @Override
    public boolean isLogToFile() {
        return logToFile;
    }

    /**
     * @param logToFile
     *            the logToFile to set
     */
    @Override
    public void setLogToFile(boolean logToFile) {
        boolean oldValue = this.logToFile;
        this.logToFile = logToFile;
        firePropertyChange(PROPERTY_LOG_TO_FILE, oldValue, logToFile);
    }

    /**
     * @return the logFileName
     */
    @Override
    public String getLogFileName() {
        return logFileName;
    }

    /**
     * @param logFileName
     *            the logFileName to set
     */
    @Override
    public void setLogFileName(String logFileName) {
        String oldValue = this.logFileName;
        this.logFileName = logFileName;
        firePropertyChange(PROPERTY_LOGFILE_NAME, oldValue, logFileName);
    }

}
