/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.wizard.tracer.service;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.core.logger.LoggerWrapper;
import org.bidib.jbidibc.messages.MessageProcessor;
import org.bidib.jbidibc.messages.exception.ProtocolException;
import org.bidib.jbidibc.messages.message.BidibMessageInterface;
import org.bidib.jbidibc.messages.message.BidibRequestFactory;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.bidib.jbidibc.messages.utils.MessageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpstreamTracerMessageProcessor
implements MessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpstreamTracerMessageProcessor.class);
    private final org.bidib.jbidibc.messages.logger.Logger messageLogger;
    private final boolean checkCRC;
    private final BidibRequestFactory requestFactory;
    private final AtomicBoolean isFirstPacket = new AtomicBoolean(true);
    private final org.bidib.jbidibc.messages.logger.Logger splitMessageLogger;

    public UpstreamTracerMessageProcessor(org.bidib.jbidibc.messages.logger.Logger messageLogger, boolean checkCRC) {
        this.messageLogger = messageLogger;
        this.requestFactory = new BidibRequestFactory();
        this.requestFactory.initialize();
        this.checkCRC = checkCRC;
        this.splitMessageLogger = new LoggerWrapper(LOGGER);
        LOGGER.info("Create new ProxyMessageProcessor with checkCRC: {}", (Object)checkCRC);
    }

    public void processMessages(ByteArrayOutputStream messageData, String contextKey) throws ProtocolException {
        if (messageData.size() < 1) {
            LOGGER.info("No data in provided buffer, skip process messages.");
            return;
        }
        MessageUtils.splitBidibMessages((org.bidib.jbidibc.messages.logger.Logger)this.splitMessageLogger, (ByteArrayOutputStream)messageData, (boolean)this.checkCRC, (AtomicBoolean)this.isFirstPacket, messageArray -> this.processMessage(messageArray, contextKey));
    }

    private void processMessage(byte[] messageArray, String contextKey) throws ProtocolException {
        this.isFirstPacket.set(false);
        BidibMessageInterface message = null;
        try {
            message = this.requestFactory.createConcreteMessage(messageArray);
            StringBuilder sb = new StringBuilder("<< ");
            sb.append(message);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])messageArray));
            this.messageLogger.info(sb.toString(), new Object[0]);
        }
        catch (ProtocolException ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray), (Object)ex);
            StringBuilder sb = new StringBuilder("<< received invalid: ");
            sb.append(message);
            sb.append(" : ");
            sb.append(ByteUtils.bytesToHex((byte[])messageArray));
            this.messageLogger.warn(sb.toString(), new Object[0]);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Process received messages failed: {}", (Object)ByteUtils.bytesToHex((byte[])messageArray), (Object)ex);
        }
    }
}

