/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.debug.rxtx;

import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.debug.DebugMessageReceiver;
import org.bidib.jbidibc.debug.rxtx.DebugReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DebugReaderTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugReaderTest.class);

    @Test(enabled=false)
    public void openDebugConnection() throws PortNotFoundException, PortNotOpenedException {
        LOGGER.info("Open the debug connection.");
        final AtomicBoolean openPortPassed = new AtomicBoolean();
        ConnectionListener connectionListener = new ConnectionListener(){

            public void opened(String port) {
                LOGGER.info("Port is opened: {}", (Object)port);
                openPortPassed.set(true);
            }

            public void closed(String port) {
                LOGGER.info("Port is closed: {}", (Object)port);
            }

            public void status(String messageKey) {
            }
        };
        Context context = null;
        DebugMessageReceiver messageProcessor = new DebugMessageReceiver();
        DebugReader debugReader = new DebugReader((DebugMessageProcessor)messageProcessor);
        debugReader.open("COM5", 115200, connectionListener, context);
        LOGGER.info("The port was opened: {}", (Object)openPortPassed);
        Assert.assertTrue((boolean)openPortPassed.get());
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Wait was interrupted.", (Throwable)e);
        }
        debugReader.close();
    }
}

