/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.debug;

import org.bidib.jbidibc.debug.DebugInterface;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.debug.scm.DebugReader;
import org.bidib.jbidibc.debug.spsw.NetDebugReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugReaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugReaderFactory.class);

    public static DebugInterface getDebugReader(SerialImpl impl, DebugMessageProcessor messageReceiver) {
        LOGGER.info("Create debug reader, serial impl: {}", (Object)impl);
        DebugInterface debugInterface = null;
        switch (impl) {
            case SCM: {
                debugInterface = new DebugReader(messageReceiver);
                break;
            }
            case SPSW_NET: {
                debugInterface = new NetDebugReader(messageReceiver);
                break;
            }
            default: {
                debugInterface = new org.bidib.jbidibc.debug.rxtx.DebugReader(messageReceiver);
            }
        }
        debugInterface.initialize();
        return debugInterface;
    }

    public static enum SerialImpl {
        RXTX,
        SCM,
        SPSW_NET;

    }
}

