/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.debug.scm;

import com.serialpundit.core.SerialComException;
import com.serialpundit.serial.ISerialComDataListener;
import com.serialpundit.serial.ISerialComEventListener;
import com.serialpundit.serial.SerialComLineEvent;
import com.serialpundit.serial.SerialComManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.exception.NoAnswerException;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.core.utils.ByteUtils;
import org.bidib.jbidibc.debug.DebugInterface;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.debug.LineEndingEnum;
import org.bidib.jbidibc.debug.exception.InvalidLibraryException;
import org.bidib.jbidibc.scm.ScmPortIdentifierUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugReader
implements DebugInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugReader.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"DEBUG_RAW");
    static final int DEFAULT_TIMEOUT = 300;
    private SerialComManager scm;
    private long handle = -1L;
    private ISerialComDataListener dataListener;
    private DebugMessageProcessor messageReceiver;
    private String requestedPortName;
    private ConnectionListener connectionListener;
    private Semaphore portSemaphore = new Semaphore(1);
    private Semaphore sendSemaphore = new Semaphore(1);
    private ISerialComEventListener eventListener;
    private boolean addEventListener = true;
    private AtomicBoolean closeInProgress = new AtomicBoolean();
    private BlockingQueue<byte[]> receiveQueue = new LinkedBlockingQueue<byte[]>();
    private Thread receiveQueueWorker;
    private AtomicBoolean receiverRunning = new AtomicBoolean();
    private AtomicLong receiveQueueWorkerThreadId = new AtomicLong();

    public DebugReader(DebugMessageProcessor messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    @Override
    public void initialize() {
    }

    @Override
    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            List portIds = ScmPortIdentifierUtils.getPortIdentifiers();
            portIdentifiers.addAll(portIds);
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ule);
            throw new InvalidLibraryException(ule.getMessage(), ule.getCause());
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        return portIdentifiers;
    }

    @Override
    public DebugMessageProcessor getMessageReceiver() {
        return this.messageReceiver;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    private long internalOpen(String portName, int baudRate, Context context) throws SerialComException {
        this.closeInProgress.set(false);
        this.startReceiveQueueWorker();
        this.handle = this.scm.openComPort(portName, true, true, true);
        LOGGER.info("Opened serial port, handle: {}", (Object)this.handle);
        this.scm.configureComPortControl(this.handle, SerialComManager.FLOWCONTROL.NONE, 'x', 'x', false, true);
        this.scm.configureComPortData(this.handle, SerialComManager.DATABITS.DB_8, SerialComManager.STOPBITS.SB_1, SerialComManager.PARITY.P_NONE, SerialComManager.BAUDRATE.valueOf((String)("B" + Integer.toString(baudRate))), 0);
        this.getConnectionListener().opened(portName);
        this.getMessageReceiver().enable();
        if (this.addEventListener) {
            this.eventListener = new ISerialComEventListener(){

                public void onNewSerialEvent(SerialComLineEvent lineEvent) {
                    LOGGER.error("eventCTS : {}, eventDSR : {}", (Object)lineEvent.getCTS(), (Object)lineEvent.getDSR());
                }
            };
            this.scm.registerLineEventListener(this.handle, this.eventListener);
        }
        this.dataListener = new ISerialComDataListener(){

            public void onNewSerialDataAvailable(byte[] data) {
                try {
                    DebugReader.this.receive(data);
                }
                catch (Exception ex) {
                    LOGGER.warn("Process received bytes failed.", (Throwable)ex);
                }
            }

            public void onDataListenerError(int errorNum) {
                LOGGER.error("Data listener notified an error: {}", (Object)errorNum);
                if (DebugReader.this.isOpened() && !DebugReader.this.closeInProgress.get()) {
                    LOGGER.info("Close the port.");
                    DebugReader.this.closeInProgress.set(true);
                    if (DebugReader.this.dataListener != null) {
                        try {
                            LOGGER.info("Unregister data listener: {}", (Object)DebugReader.this.dataListener);
                            DebugReader.this.scm.unregisterDataListener(DebugReader.this.handle, DebugReader.this.dataListener);
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Unregister data listener after error detection failed.", (Throwable)ex);
                        }
                        DebugReader.this.dataListener = null;
                    }
                    Thread t1 = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            LOGGER.info("Error detected. Close the port.");
                            try {
                                DebugReader.this.close();
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Close scm port failed.", (Throwable)ex);
                            }
                        }
                    });
                    t1.start();
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for close thread to startup was interrupted.", (Throwable)ex);
                    }
                } else {
                    LOGGER.info("Port is closed.");
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warn("Wait for close thread was interrupted.", (Throwable)ex);
                    }
                }
            }
        };
        LOGGER.info("Registering data listener fro handle: {}.", (Object)this.handle);
        this.scm.registerDataListener(this.handle, this.dataListener);
        LOGGER.info("Registered data listener.");
        try {
            LOGGER.info("Activate DTR.");
            this.scm.setDTR(this.handle, true);
        }
        catch (Exception e) {
            LOGGER.warn("Set DTR true failed.", (Throwable)e);
        }
        try {
            LOGGER.info("Activate RTS.");
            this.scm.setRTS(this.handle, true);
        }
        catch (Exception e) {
            LOGGER.warn("Set RTS true failed.", (Throwable)e);
        }
        return this.handle;
    }

    @Override
    public void close() {
        if (this.scm != null) {
            LOGGER.info("Close the port, handle: {}", (Object)this.handle);
            long start = System.currentTimeMillis();
            LOGGER.info("Unregister data listener: {}", (Object)this.dataListener);
            if (this.dataListener != null && this.handle > -1L) {
                try {
                    this.scm.unregisterDataListener(this.handle, this.dataListener);
                }
                catch (SerialComException ex) {
                    LOGGER.warn("Unregister dataListener failed.", (Throwable)ex);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Sleep after unregister data listener failed.", (Throwable)ex);
                }
            }
            this.dataListener = null;
            if (this.eventListener != null && this.handle > -1L) {
                LOGGER.info("Unregister line event listener.");
                try {
                    this.scm.unregisterLineEventListener(this.handle, this.eventListener);
                }
                catch (SerialComException ex) {
                    LOGGER.warn("Unregister lineEventListener failed.", (Throwable)ex);
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Sleep after unregister line event listener failed.", (Throwable)ex);
                }
            }
            this.eventListener = null;
            this.getMessageReceiver().disable();
            this.stopReceiveQueueWorker();
            if (this.handle > -1L) {
                try {
                    LOGGER.info("Close the COM port: {}", (Object)this.handle);
                    this.scm.closeComPort(this.handle);
                }
                catch (Exception e) {
                    LOGGER.warn("Close port failed.", (Throwable)e);
                }
            } else {
                LOGGER.info("Don't close port because handle is not valid.");
            }
            long end = System.currentTimeMillis();
            LOGGER.info("Closed the port. duration: {}", (Object)(end - start));
            this.scm = null;
            this.handle = -1L;
            if (this.connectionListener != null) {
                this.connectionListener.closed(this.requestedPortName);
            }
            this.requestedPortName = null;
        }
    }

    @Override
    public boolean isOpened() {
        boolean isOpened = this.handle > -1L;
        return isOpened;
    }

    @Override
    public void open(String portName, int baudRate, ConnectionListener connectionListener, Context context) throws PortNotFoundException, PortNotOpenedException {
        block16: {
            this.setConnectionListener(connectionListener);
            if (this.scm == null) {
                if (portName == null || portName.trim().isEmpty()) {
                    throw new PortNotFoundException("");
                }
                LOGGER.info("Open port with name: {}, baudRate: {}", (Object)portName, (Object)baudRate);
                this.requestedPortName = portName;
                try {
                    this.portSemaphore.acquire();
                    try {
                        this.close();
                        String tempDir = System.getProperty("java.io.tmpdir");
                        String appSuffix = System.getProperty("jbidibc.appsuffix");
                        StringBuilder scmExpandFile = new StringBuilder("jbidibc");
                        if (StringUtils.isNotBlank((CharSequence)appSuffix)) {
                            scmExpandFile.append("-").append(appSuffix);
                        }
                        LOGGER.info("Prepared scmExpandFile: {}", (Object)scmExpandFile);
                        File temp = new File(tempDir, scmExpandFile.toString());
                        this.scm = new SerialComManager("scm", temp.getAbsolutePath(), true, false);
                        this.internalOpen(portName, baudRate, context);
                        LOGGER.info("The port was opened internally.");
                        break block16;
                    }
                    catch (NoAnswerException naex) {
                        LOGGER.warn("Open communication failed.", (Throwable)naex);
                        try {
                            this.close();
                        }
                        catch (Exception appSuffix) {
                            // empty catch block
                        }
                        throw naex;
                    }
                    catch (Exception e2) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)e2);
                        try {
                            this.close();
                        }
                        catch (Exception e3) {
                            LOGGER.warn("Close port failed.", (Throwable)e3);
                        }
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                    catch (UnsatisfiedLinkError err) {
                        LOGGER.info("Open port failed. Close port and throw exception.", (Throwable)err);
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                    throw new PortNotOpenedException(portName, "unknown");
                }
                finally {
                    this.portSemaphore.release();
                }
            }
            LOGGER.warn("Port is already opened.");
        }
    }

    @Override
    public void send(String message, LineEndingEnum lineEnding) {
        if (this.handle > -1L) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> '{}'", (Object)message);
                }
                this.scm.writeBytes(this.handle, message.getBytes());
                this.scm.writeBytes(this.handle, lineEnding.getValues());
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    @Override
    public void send(byte[] content) {
        if (this.handle > -1L) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> '{}'", (Object)ByteUtils.bytesToHex((byte[])content));
                }
                this.scm.writeBytes(this.handle, content);
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    private void receive(byte[] bytes) {
        boolean added;
        byte[] buffer = new byte[bytes.length];
        System.arraycopy(bytes, 0, buffer, 0, bytes.length);
        if (MSG_RAW_LOGGER.isInfoEnabled()) {
            MSG_RAW_LOGGER.info("<<<< len: {}, data: {}", (Object)bytes.length, (Object)ByteUtils.bytesToHex((byte[])buffer));
        }
        if (!(added = this.receiveQueue.offer(buffer))) {
            LOGGER.error("The message was not added to the receive queue: {}", (Object)ByteUtils.bytesToHex((byte[])buffer));
        }
    }

    private void startReceiveQueueWorker() {
        this.receiverRunning.set(true);
        LOGGER.info("Start the receiveQueueWorker. Current receiveQueueWorker: {}", (Object)this.receiveQueueWorker);
        this.receiveQueueWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DebugReader.this.processReceiveQueue();
                }
                catch (Exception ex) {
                    LOGGER.warn("The processing of the receive queue was terminated with an exception!", (Throwable)ex);
                }
                LOGGER.info("Process receive queue has finished.");
            }
        }, "receiveQueueWorker");
        try {
            this.receiveQueueWorkerThreadId.set(this.receiveQueueWorker.getId());
            this.receiveQueueWorker.start();
        }
        catch (Exception ex) {
            LOGGER.error("Start the receiveQueueWorker failed.", (Throwable)ex);
        }
    }

    private void stopReceiveQueueWorker() {
        LOGGER.info("Stop the receive queue worker.");
        this.receiverRunning.set(false);
        try {
            this.receiveQueueWorker.interrupt();
            this.receiveQueueWorker.join(1000L);
            LOGGER.info("receiveQueueWorker has finished.");
        }
        catch (Exception ex) {
            LOGGER.warn("Interrupt receiveQueueWorker failed.", (Throwable)ex);
        }
        this.receiveQueueWorker = null;
    }

    private void processReceiveQueue() {
        byte[] bytes = null;
        LOGGER.info("The receiveQueueWorker is ready for processing.");
        while (this.receiverRunning.get()) {
            try {
                bytes = this.receiveQueue.take();
                if (bytes == null) continue;
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    output.write(bytes);
                    this.getMessageReceiver().processMessages(output);
                }
                catch (Exception ex) {
                    LOGGER.warn("Process received bytes failed.", (Throwable)ex);
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Get message from receiveQueue failed because thread was interrupted.");
            }
            catch (Exception ex) {
                LOGGER.warn("Get message from receiveQueue failed.", (Throwable)ex);
                bytes = null;
            }
        }
        LOGGER.info("The receiveQueueWorker has finished processing.");
        this.receiveQueueWorkerThreadId.set(0L);
    }
}

