/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.debug;

import java.lang.reflect.Constructor;
import org.bidib.jbidibc.core.exception.InvalidConfigurationException;
import org.bidib.jbidibc.debug.DebugInterface;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugReaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugReaderFactory.class);

    public static DebugInterface getDebugReader(SerialImpl impl, DebugMessageProcessor messageReceiver) {
        LOGGER.info("Create debug reader, serial impl: {}", (Object)impl);
        DebugInterface debugInterface = null;
        String clazzName = impl.getImplClass();
        try {
            Class<?> clazz = Class.forName(clazzName);
            Constructor<?> method = clazz.getConstructor(DebugMessageProcessor.class);
            debugInterface = (DebugInterface)method.newInstance(messageReceiver);
        }
        catch (Exception ex) {
            LOGGER.error("Create debugReader instance with newInstance failed: {}", (Object)clazzName, (Object)ex);
            throw new InvalidConfigurationException("Create debugReader instance failed: " + clazzName);
        }
        debugInterface.initialize();
        return debugInterface;
    }

    public static enum SerialImpl {
        RXTX("org.bidib.jbidibc.rxtx.debug.DebugReader"),
        PUREJAVACOMM("org.bidib.jbidibc.purejavacomm.debug.DebugReader"),
        SCM("org.bidib.jbidibc.scm.debug.DebugReader"),
        SPSW_NET("org.bidib.jbidibc.spsw.debug.NetDebugReader");

        String implClass;

        private SerialImpl(String implClass) {
            this.implClass = implClass;
        }

        public String getImplClass() {
            return this.implClass;
        }
    }
}

