/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.debug;

import gnu.io.SerialPort;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.debug.DebugMessageListener;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugMessageReceiver
implements DebugMessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugMessageReceiver.class);
    private ByteArrayOutputStream output = new ByteArrayOutputStream();
    protected AtomicBoolean running = new AtomicBoolean();
    private byte[] inputBuffer = new byte[1024];
    private final Set<DebugMessageListener> messageListeners = Collections.synchronizedSet(new LinkedHashSet());

    public DebugMessageReceiver() {
        this.running.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(DebugMessageListener listener) {
        Set<DebugMessageListener> set = this.messageListeners;
        synchronized (set) {
            if (!this.messageListeners.contains(listener)) {
                LOGGER.info("Add new message listener: {}", (Object)listener);
                this.messageListeners.add(listener);
            } else {
                LOGGER.warn("Message listener is already registered: {}", (Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(DebugMessageListener listener) {
        Set<DebugMessageListener> set = this.messageListeners;
        synchronized (set) {
            if (this.messageListeners.contains(listener)) {
                LOGGER.info("Remove message listener: {}", (Object)listener);
                this.messageListeners.remove(listener);
            } else {
                LOGGER.warn("Message listener was not registered: {}", (Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processMessages(ByteArrayOutputStream output) {
        String message = output.toString();
        LOGGER.debug("processMessages, received message: {}", (Object)message);
        output.reset();
        Set<DebugMessageListener> set = this.messageListeners;
        synchronized (set) {
            for (DebugMessageListener l : this.messageListeners) {
                l.debugMessage(message);
            }
        }
    }

    @Override
    public void disable() {
        this.running.set(false);
    }

    @Override
    public void enable() {
        this.running.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(SerialPort port) {
        LOGGER.debug("Start receiving messages.");
        DebugMessageReceiver debugMessageReceiver = this;
        synchronized (debugMessageReceiver) {
            LOGGER.debug("Starting message receiver.");
            try {
                InputStream input = null;
                if (port != null) {
                    input = port.getInputStream();
                }
                if (input != null) {
                    int len = input.read(this.inputBuffer);
                    if (len > 0) {
                        this.output.write(this.inputBuffer, 0, len);
                        this.processMessages(this.output);
                        LOGGER.debug("Leaving receive loop, RUNNING: {}", (Object)this.running);
                        if (this.output != null && this.output.size() > 0) {
                            LOGGER.warn("Data in output: {}", (Object)this.output.toString());
                        }
                    }
                } else {
                    LOGGER.error("No input available.");
                }
            }
            catch (Exception e) {
                LOGGER.warn("Exception detected in message receiver!", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    public static String bytesToStringUTFCustom(byte[] bytes) {
        char[] buffer = new char[bytes.length >> 1];
        for (int i = 0; i < buffer.length; ++i) {
            char c;
            int bpos = i << 1;
            buffer[i] = c = (char)(((bytes[bpos] & 0xFF) << 8) + (bytes[bpos + 1] & 0xFF));
        }
        return new String(buffer);
    }
}

