/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.debug;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.concurrent.Semaphore;
import org.bidib.jbidibc.core.ConnectionListener;
import org.bidib.jbidibc.core.exception.PortNotFoundException;
import org.bidib.jbidibc.core.exception.PortNotOpenedException;
import org.bidib.jbidibc.core.helpers.Context;
import org.bidib.jbidibc.debug.DebugInterface;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.debug.exception.InvalidLibraryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugReader
implements DebugInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugReader.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"DEBUG_RAW");
    static final int DEFAULT_TIMEOUT = 300;
    private SerialPort port;
    private DebugMessageProcessor messageReceiver;
    private String requestedPortName;
    private ConnectionListener connectionListener;
    private Semaphore portSemaphore = new Semaphore(1);
    private Semaphore sendSemaphore = new Semaphore(1);

    public DebugReader(DebugMessageProcessor messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    @Override
    public List<String> getPortIdentifiers() {
        ArrayList<String> portIdentifiers = new ArrayList<String>();
        try {
            Enumeration e = CommPortIdentifier.getPortIdentifiers();
            while (e.hasMoreElements()) {
                CommPortIdentifier id = (CommPortIdentifier)e.nextElement();
                LOGGER.debug("Process current CommPortIdentifier, name: {}, portType: {}", (Object)id.getName(), (Object)id.getPortType());
                if (id.getPortType() == 1) {
                    portIdentifiers.add(id.getName());
                    continue;
                }
                LOGGER.debug("Skip port because no serial port, name: {}, portType: {}", (Object)id.getName(), (Object)id.getPortType());
            }
        }
        catch (UnsatisfiedLinkError ule) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)ule);
            throw new InvalidLibraryException(ule.getMessage(), ule.getCause());
        }
        catch (Error error) {
            LOGGER.warn("Get comm port identifiers failed.", (Throwable)error);
            throw new RuntimeException(error.getMessage(), error.getCause());
        }
        return portIdentifiers;
    }

    @Override
    public DebugMessageProcessor getMessageReceiver() {
        return this.messageReceiver;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    private SerialPort internalOpen(CommPortIdentifier commPort, int baudRate, Context context) throws PortInUseException, UnsupportedCommOperationException, TooManyListenersException {
        RXTXPort serialPort = commPort.open(DebugReader.class.getName(), 2000);
        this.getConnectionListener().opened(commPort.getName());
        LOGGER.info("Set flow control mode to SerialPort.FLOWCONTROL_NONE!");
        serialPort.setFlowControlMode(0);
        serialPort.enableReceiveTimeout(300);
        serialPort.setSerialPortParams(baudRate, 8, 1, 0);
        this.clearInputStream((SerialPort)serialPort);
        try {
            LOGGER.info("Activate DTR.");
            serialPort.setDTR(true);
        }
        catch (Exception e) {
            LOGGER.warn("Set DTR true failed.", (Throwable)e);
        }
        this.getMessageReceiver().enable();
        serialPort.addEventListener(new SerialPortEventListener(){

            public void serialEvent(SerialPortEvent event) {
                LOGGER.trace("serialEvent received: {}", (Object)event);
                switch (event.getEventType()) {
                    case 1: {
                        try {
                            DebugReader.this.getMessageReceiver().receive(DebugReader.this.port);
                        }
                        catch (Exception ex) {
                            LOGGER.error("Message receiver has terminated with an exception!", (Throwable)ex);
                        }
                        break;
                    }
                    case 2: {
                        LOGGER.trace("The output buffer is empty.");
                        break;
                    }
                    case 6: {
                        LOGGER.warn("CD is signalled.");
                        break;
                    }
                    case 3: {
                        LOGGER.warn("The CTS value has changed, old value: {}, new value: {}", new Object[]{event.getOldValue(), event.getNewValue()});
                        if (event.getNewValue()) break;
                        LOGGER.warn("Close the port.");
                        Thread worker = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                LOGGER.info("Start close port because error was detected.");
                                try {
                                    DebugReader.this.close();
                                }
                                catch (Exception ex) {
                                    LOGGER.warn("Close after error failed.", (Throwable)ex);
                                }
                                LOGGER.warn("The port was closed.");
                            }
                        });
                        worker.start();
                        break;
                    }
                    default: {
                        LOGGER.warn("SerialPortEvent was triggered, type: {}, old value: {}, new value: {}", new Object[]{event.getEventType(), event.getOldValue(), event.getNewValue()});
                    }
                }
            }
        });
        serialPort.notifyOnDataAvailable(true);
        serialPort.notifyOnCTS(true);
        serialPort.notifyOnCarrierDetect(true);
        serialPort.notifyOnBreakInterrupt(true);
        serialPort.notifyOnDSR(true);
        serialPort.notifyOnOverrunError(true);
        serialPort.setRTS(true);
        return serialPort;
    }

    private void clearInputStream(SerialPort serialPort) {
        try {
            InputStream serialStream = serialPort.getInputStream();
            int count = serialStream.available();
            LOGGER.debug("input stream shows {} bytes available", (Object)count);
            while (count > 0) {
                serialStream.skip(count);
                count = serialStream.available();
            }
            LOGGER.debug("input stream shows {} bytes available after purge.", (Object)count);
        }
        catch (Exception e) {
            LOGGER.warn("Clear input stream failed.", (Throwable)e);
        }
    }

    @Override
    public void close() {
        if (this.port != null) {
            LOGGER.debug("Close the port.");
            long start = System.currentTimeMillis();
            this.getMessageReceiver().disable();
            try {
                this.port.removeEventListener();
                this.port.enableReceiveTimeout(200);
            }
            catch (UnsupportedCommOperationException e) {
            }
            catch (Exception e) {
                LOGGER.warn("Remove event listener and set receive timeout failed.", (Throwable)e);
            }
            try {
                this.port.close();
            }
            catch (Exception e) {
                LOGGER.warn("Close port failed.", (Throwable)e);
            }
            long end = System.currentTimeMillis();
            LOGGER.debug("Closed the port. duration: {}", (Object)(end - start));
            this.port = null;
            this.requestedPortName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOpened() {
        boolean isOpened = false;
        try {
            this.portSemaphore.acquire();
            LOGGER.debug("Check if port is opened: {}", (Object)this.port);
            isOpened = this.port != null && this.port.getOutputStream() != null;
        }
        catch (InterruptedException ex) {
            LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
        }
        catch (IOException ex) {
            LOGGER.warn("OutputStream is not available.", (Throwable)ex);
        }
        finally {
            this.portSemaphore.release();
        }
        return isOpened;
    }

    @Override
    public void open(String portName, int baudRate, ConnectionListener connectionListener, Context context) throws PortNotFoundException, PortNotOpenedException {
        block19: {
            this.setConnectionListener(connectionListener);
            if (this.port == null) {
                if (portName == null || portName.trim().isEmpty()) {
                    throw new PortNotFoundException("");
                }
                LOGGER.info("Open port with name: {}", (Object)portName);
                File file = new File(portName);
                if (file.exists()) {
                    try {
                        portName = file.getCanonicalPath();
                        LOGGER.info("Changed port name to: {}", (Object)portName);
                    }
                    catch (IOException ex) {
                        throw new PortNotFoundException(portName);
                    }
                }
                CommPortIdentifier commPort = null;
                try {
                    commPort = CommPortIdentifier.getPortIdentifier((String)portName);
                }
                catch (NoSuchPortException ex) {
                    LOGGER.warn("Requested port is not available: {}", (Object)portName, (Object)ex);
                    throw new PortNotFoundException(portName);
                }
                LOGGER.info("Set the requestedPortName: {}, baudRate: {}", (Object)portName, (Object)baudRate);
                this.requestedPortName = portName;
                try {
                    this.portSemaphore.acquire();
                    try {
                        this.close();
                        this.port = this.internalOpen(commPort, baudRate, context);
                        LOGGER.info("The port was opened internally.");
                        break block19;
                    }
                    catch (PortInUseException ex) {
                        LOGGER.warn("Open communication failed because port is in use.", (Throwable)ex);
                        try {
                            this.close();
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        throw new PortNotOpenedException(portName, "portInUse");
                    }
                    catch (UnsupportedCommOperationException | TooManyListenersException ex) {
                        LOGGER.warn("Open communication failed because port has thrown an exception.", ex);
                        try {
                            this.close();
                        }
                        catch (Exception e4) {
                            // empty catch block
                        }
                        throw new PortNotOpenedException(portName, "unknown");
                    }
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for portSemaphore was interrupted.", (Throwable)ex);
                    throw new PortNotOpenedException(portName, "unknown");
                }
                finally {
                    this.portSemaphore.release();
                }
            }
            LOGGER.warn("Port is already opened.");
        }
    }

    @Override
    public void send(String message) {
        if (this.port != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> '{}'", (Object)message);
                }
                OutputStream output = this.port.getOutputStream();
                output.write(message.getBytes());
                output.write(13);
                output.write(10);
                output.flush();
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }

    @Override
    public void send(byte[] content) {
        if (this.port != null) {
            try {
                this.sendSemaphore.acquire();
                if (MSG_RAW_LOGGER.isInfoEnabled()) {
                    MSG_RAW_LOGGER.info(">> '{}'", (Object)content);
                }
                OutputStream output = this.port.getOutputStream();
                output.write(content);
                output.flush();
            }
            catch (Exception e) {
                throw new RuntimeException("Send message to output stream failed.", e);
            }
            finally {
                this.sendSemaphore.release();
            }
        }
    }
}

