package org.bidib.jbidibc.debug;

import java.lang.reflect.Constructor;

import org.bidib.jbidibc.messages.exception.InvalidConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugReaderFactory {

    private static final Logger LOGGER = LoggerFactory.getLogger(DebugReaderFactory.class);

    public enum SerialImpl {
        // @formatter:off
        
        RXTX("org.bidib.jbidibc.rxtx.debug.DebugReader"), 
        PUREJAVACOMM("org.bidib.jbidibc.purejavacomm.debug.DebugReader"), 
        SCM("org.bidib.jbidibc.scm.debug.DebugReader"), 
        SPSW_NET("org.bidib.jbidibc.spsw.debug.NetDebugReader");
        
        // @formatter:on

        String implClass;

        SerialImpl(String implClass) {
            this.implClass = implClass;
        }

        public String getImplClass() {
            return implClass;
        }
    }

    public static DebugInterface getDebugReader(SerialImpl impl, final DebugMessageProcessor messageReceiver) {
        LOGGER.info("Create debug reader, serial impl: {}", impl);

        DebugInterface debugInterface = null;

        final String clazzName = impl.getImplClass();

        try {
            Class<?> clazz = Class.forName(clazzName);

            Constructor<?> method = clazz.getConstructor(DebugMessageProcessor.class);
            debugInterface = (DebugInterface) method.newInstance(messageReceiver);
        }
        catch (Exception ex) {
            LOGGER.error("Create debugReader instance with newInstance failed: {}", clazzName, ex);

            throw new InvalidConfigurationException("Create debugReader instance failed: " + clazzName);
        }

        debugInterface.initialize();

        return debugInterface;
    }
}
