/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.debug;

import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bidib.jbidibc.debug.DebugMessageListener;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugMessageReceiver
implements DebugMessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebugMessageReceiver.class);
    protected AtomicBoolean running = new AtomicBoolean();
    private final Set<DebugMessageListener> messageListeners = Collections.synchronizedSet(new LinkedHashSet());

    public DebugMessageReceiver() {
        this.running.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(DebugMessageListener listener) {
        Set<DebugMessageListener> set = this.messageListeners;
        synchronized (set) {
            if (!this.messageListeners.contains(listener)) {
                LOGGER.info("Add new message listener: {}", (Object)listener);
                this.messageListeners.add(listener);
            } else {
                LOGGER.warn("Message listener is already registered: {}", (Object)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(DebugMessageListener listener) {
        Set<DebugMessageListener> set = this.messageListeners;
        synchronized (set) {
            if (this.messageListeners.contains(listener)) {
                LOGGER.info("Remove message listener: {}", (Object)listener);
                this.messageListeners.remove(listener);
            } else {
                LOGGER.warn("Message listener was not registered: {}", (Object)listener);
            }
        }
    }

    @Override
    public void processMessages(ByteArrayOutputStream output) {
        String message = output.toString();
        LOGGER.debug("processMessages, received message: {}", (Object)message);
        output.reset();
        this.publishMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publishMessage(String message) {
        Set<DebugMessageListener> set = this.messageListeners;
        synchronized (set) {
            for (DebugMessageListener l : this.messageListeners) {
                l.debugMessage(message);
            }
        }
    }

    @Override
    public void disable() {
        this.running.set(false);
    }

    @Override
    public void enable() {
        this.running.set(true);
    }

    public static String bytesToStringUTFCustom(byte[] bytes) {
        char[] buffer = new char[bytes.length >> 1];
        for (int i = 0; i < buffer.length; ++i) {
            char c;
            int bpos = i << 1;
            buffer[i] = c = (char)(((bytes[bpos] & 0xFF) << 8) + (bytes[bpos + 1] & 0xFF));
        }
        return new String(buffer);
    }
}

