/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.debug;

import java.io.ByteArrayOutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.bidib.jbidibc.debug.DebugInterface;
import org.bidib.jbidibc.debug.DebugMessageProcessor;
import org.bidib.jbidibc.messages.ConnectionListener;
import org.bidib.jbidibc.messages.helpers.Context;
import org.bidib.jbidibc.messages.utils.ByteUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDebugReader
implements DebugInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDebugReader.class);
    private static final Logger MSG_RAW_LOGGER = LoggerFactory.getLogger((String)"DEBUG_RAW");
    private final DebugMessageProcessor messageReceiver;
    private ConnectionListener connectionListener;
    private String requestedPortName;
    private final AtomicBoolean sendEnabled = new AtomicBoolean();
    private BlockingQueue<byte[]> receiveQueue = new LinkedBlockingQueue<byte[]>();
    private Thread receiveQueueWorker;
    protected Thread receiverThread;
    protected AtomicBoolean receiverRunning = new AtomicBoolean();
    private AtomicLong receiveQueueWorkerThreadId = new AtomicLong();

    public AbstractDebugReader(DebugMessageProcessor messageReceiver) {
        this.messageReceiver = messageReceiver;
    }

    @Override
    public void initialize() {
    }

    protected void setSendEnabled(boolean sendEnabled) {
        this.sendEnabled.set(sendEnabled);
    }

    protected void setRequestedPortName(String requestedPortName) {
        this.requestedPortName = requestedPortName;
    }

    protected String getRequestedPortName() {
        return this.requestedPortName;
    }

    @Override
    public DebugMessageProcessor getMessageReceiver() {
        return this.messageReceiver;
    }

    public ConnectionListener getConnectionListener() {
        return this.connectionListener;
    }

    public void setConnectionListener(ConnectionListener connectionListener) {
        this.connectionListener = connectionListener;
    }

    public void startReceiverAndQueues(DebugMessageProcessor serialMessageReceiver, Context context) {
        LOGGER.info("Start receiver and queues.");
        if (this.receiverThread == null) {
            this.receiverThread = this.createReceiverThread();
        }
        if (this.receiverThread != null) {
            this.receiverThread.start();
        }
        serialMessageReceiver.enable();
        this.startReceiveQueueWorker();
    }

    protected Thread createReceiverThread() {
        return null;
    }

    protected void addDataToReceiveQueue(ByteArrayOutputStream output) {
        byte[] bytes = output.toByteArray();
        byte[] buffer = new byte[bytes.length];
        System.arraycopy(bytes, 0, buffer, 0, bytes.length);
        this.addDataToReceiveQueue(buffer);
        output.reset();
    }

    protected void addDataToReceiveQueue(byte[] data) {
        boolean added;
        if (MSG_RAW_LOGGER.isInfoEnabled()) {
            MSG_RAW_LOGGER.info("<<<< len: {}, data: {}", (Object)data.length, (Object)ByteUtils.bytesToHex((byte[])data));
        }
        if (!(added = this.receiveQueue.offer(data))) {
            LOGGER.error("The message was not added to the receive queue: {}", (Object)ByteUtils.bytesToHex((byte[])data));
        }
    }

    protected void startReceiveQueueWorker() {
        this.receiverRunning.set(true);
        LOGGER.info("Start the receiveQueueWorker. Current receiveQueueWorker: {}", (Object)this.receiveQueueWorker);
        this.receiveQueueWorker = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    AbstractDebugReader.this.processReceiveQueue();
                }
                catch (Exception ex) {
                    LOGGER.warn("The processing of the receive queue was terminated with an exception!", (Throwable)ex);
                }
                LOGGER.info("Process receive queue has finished.");
            }
        }, "receiveQueueWorker");
        try {
            this.receiveQueueWorkerThreadId.set(this.receiveQueueWorker.getId());
            this.receiveQueueWorker.start();
        }
        catch (Exception ex) {
            LOGGER.error("Start the receiveQueueWorker failed.", (Throwable)ex);
        }
        LOGGER.info("Start the receiveQueueWorker finished. Current receiveQueueWorker: {}", (Object)this.receiveQueueWorker);
    }

    protected void stopReceiveQueueWorker() {
        LOGGER.info("Stop the receive queue worker.");
        this.receiverRunning.set(false);
        try {
            this.receiveQueueWorker.interrupt();
            this.receiveQueueWorker.join(1000L);
            LOGGER.info("receiveQueueWorker has finished.");
        }
        catch (Exception ex) {
            LOGGER.warn("Interrupt receiveQueueWorker failed.", (Throwable)ex);
        }
        this.receiveQueueWorker = null;
    }

    private void processReceiveQueue() {
        byte[] bytes = null;
        LOGGER.info("The receiveQueueWorker is ready for processing, requestedPortName: {}", (Object)this.requestedPortName);
        while (this.receiverRunning.get()) {
            try {
                bytes = this.receiveQueue.take();
                if (bytes == null) continue;
                try {
                    ByteArrayOutputStream output = new ByteArrayOutputStream();
                    output.write(bytes);
                    this.getMessageReceiver().processMessages(output);
                }
                catch (Exception ex) {
                    LOGGER.warn("Process received bytes failed.", (Throwable)ex);
                }
            }
            catch (InterruptedException ex) {
                LOGGER.warn("Get message from receiveQueue failed because thread was interrupted.");
            }
            catch (Exception ex) {
                LOGGER.warn("Get message from receiveQueue failed.", (Throwable)ex);
                bytes = null;
            }
        }
        LOGGER.info("The receiveQueueWorker has finished processing, requestedPortName: {}", (Object)this.requestedPortName);
        this.receiveQueueWorkerThreadId.set(0L);
    }

    protected void closeHandle() {
    }

    protected void triggerClosePort() {
        LOGGER.warn("Close the port.");
        Thread worker = new Thread(() -> {
            LOGGER.info("Start close port because error was detected.");
            try {
                this.close();
            }
            catch (Exception ex) {
                LOGGER.warn("Close after error failed.", (Throwable)ex);
            }
            LOGGER.warn("The port was closed.");
        });
        worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopReceiverThread() {
        LOGGER.info("Stop the receiver thread by set the running flag to false.");
        this.receiverRunning.set(false);
        if (this.receiverThread != null) {
            LOGGER.info("Wait for termination of receiver thread.");
            Thread thread = this.receiverThread;
            synchronized (thread) {
                this.closeHandle();
                try {
                    this.receiverThread.join(5000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.warn("Wait for termination of receiver thread failed.", (Throwable)ex);
                }
            }
            LOGGER.info("Free the receiver thread.");
            this.receiverThread = null;
        }
    }
}

