/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import com.github.markusbernhardt.proxy.ProxySearch;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.http.HttpHost;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.bidib.jbidibc.decoder.json.DecoderDbStatusResponse;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturerType;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersList;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DecoderDbStatusResponseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderDbStatusResponseTest.class);
    private static final String REST_SERVICE_URI = "https://www.decoderdb.de";

    @Test
    public void listAll() throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        mapper.registerModule((Module)module);
        InputStream is = DecoderDbStatusResponseTest.class.getResourceAsStream("/json/listAll.json");
        DecoderDbStatusResponse listAll = (DecoderDbStatusResponse)mapper.readValue(is, DecoderDbStatusResponse.class);
        LOGGER.info("Loaded listAll: {}", (Object)listAll);
        Assert.assertNotNull((Object)listAll);
        Assert.assertNotNull((Object)listAll.getManufacturers());
        Assert.assertEquals((String)listAll.getManufacturers().getFilename(), (String)"Manufacturers.xml");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(2016, 4, 19, 0, 0, 0);
        cal.set(14, 0);
        Assert.assertEquals((Object)listAll.getManufacturers().getNmraListDate(), (Object)cal.getTime());
        Assert.assertTrue((boolean)listAll.getManufacturers().isValid());
        Assert.assertNotNull((Object)listAll.getDecoderDetections());
        Assert.assertEquals((String)listAll.getDecoderDetections().getFilename(), (String)"decoderDetection.xml");
        Assert.assertEquals((String)listAll.getDecoderDetections().getLink(), (String)"https://www.decoderdb.de/?decoderdetection");
        Assert.assertTrue((boolean)listAll.getDecoderDetections().isValid());
        Assert.assertNotNull((Object)listAll.getDecoder());
        Assert.assertEquals((int)listAll.getDecoder().length, (int)15);
        DecoderDbStatusResponse.DecoderStatusResponse product = listAll.getDecoder()[0];
        Assert.assertNotNull((Object)product);
        Assert.assertEquals((String)product.getFilename(), (String)"Product_0_NMRA-Standard.xml");
        Assert.assertEquals((Object)product.getManufacturerId(), (Object)0);
        Assert.assertNull((Object)product.getManufacturerExtendedId());
        Assert.assertEquals((String)product.getName(), (String)"NMRA-Standard");
        product = listAll.getDecoder()[1];
        Assert.assertNotNull((Object)product);
        Assert.assertEquals((String)product.getFilename(), (String)"Product_13-256_DecoderDBLok.xml");
        Assert.assertEquals((Object)product.getManufacturerId(), (Object)13);
        Assert.assertEquals((Object)product.getManufacturerExtendedId(), (Object)256);
        Assert.assertEquals((String)product.getName(), (String)"Decoder DB Lok");
    }

    @Test(enabled=true)
    public void listManufacturersRemote() throws MalformedURLException, URISyntaxException {
        LOGGER.info("listManufacturersRemote");
        String plainCreds = "cv:cv";
        byte[] plainCredsBytes = plainCreds.getBytes();
        byte[] base64CredsBytes = Base64.encodeBase64((byte[])plainCredsBytes);
        String base64Creds = new String(base64CredsBytes);
        LOGGER.info("base64Creds: {}", (Object)base64Creds);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Creds);
        RestTemplate restTemplate = this.createRestTemplate(REST_SERVICE_URI);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange("https://www.decoderdb.de/?manufacturers", HttpMethod.GET, request, ManufacturersList.class, new Object[0]);
        ManufacturersList listManufacturers = (ManufacturersList)response.getBody();
        LOGGER.info("Retrieved listManufacturers: {}", (Object)listManufacturers);
        Assert.assertNotNull((Object)listManufacturers);
        Assert.assertNotNull((Object)listManufacturers.getManufacturers());
        Assert.assertNotNull((Object)listManufacturers.getManufacturers().getManufacturer());
        Assert.assertFalse((boolean)listManufacturers.getManufacturers().getManufacturer().isEmpty());
        int ID = 13;
        List manufacturers = listManufacturers.getManufacturers().getManufacturer();
        ManufacturerType manufacturerDiy = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13;
            }
        });
        Assert.assertNotNull((Object)manufacturerDiy);
        LOGGER.info("Found DIY manufacturer: {}", (Object)manufacturerDiy);
        final Integer EXTENDED_ID_OPENDCC = 258;
        ManufacturerType manufacturerOpenDcc = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13 && EXTENDED_ID_OPENDCC.equals(manufacturer.getExtendedId());
            }
        });
        Assert.assertNotNull((Object)manufacturerOpenDcc);
        LOGGER.info("Found OpenDCC manufacturer: {}", (Object)manufacturerOpenDcc);
    }

    @Test(enabled=true)
    public void listAllRemote() throws MalformedURLException, URISyntaxException {
        LOGGER.info("listAllRemote");
        String plainCreds = "cv:cv";
        byte[] plainCredsBytes = plainCreds.getBytes();
        byte[] base64CredsBytes = Base64.encodeBase64((byte[])plainCredsBytes);
        String base64Creds = new String(base64CredsBytes);
        LOGGER.info("base64Creds: {}", (Object)base64Creds);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Creds);
        RestTemplate restTemplate = this.createRestTemplate(REST_SERVICE_URI);
        HttpEntity request = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange("https://www.decoderdb.de/?listAll", HttpMethod.GET, request, DecoderDbStatusResponse.class, new Object[0]);
        DecoderDbStatusResponse listAll = (DecoderDbStatusResponse)response.getBody();
        LOGGER.info("Retrieved listAll: {}", (Object)listAll);
        DecoderDbStatusResponse.ManufacturersStatusResponse manufacturersStatusResponse = listAll.getManufacturers();
        Assert.assertNotNull((Object)manufacturersStatusResponse);
        Date nmraListDate = manufacturersStatusResponse.getNmraListDate();
        Assert.assertNotNull((Object)nmraListDate);
        Date lastUpdate = manufacturersStatusResponse.getLastUpdate();
        Assert.assertNotNull((Object)lastUpdate);
        DecoderDbStatusResponse.DecoderStatusResponse[] decoders = listAll.getDecoder();
        Assert.assertNotNull((Object)decoders);
        Assert.assertTrue((decoders.length > 0 ? 1 : 0) != 0);
        LOGGER.info("Current decoders: {}", new Object[]{decoders});
        DecoderDbStatusResponse.FirmwareStatusResponse[] firmwareItems = listAll.getFirmware();
        Assert.assertNotNull((Object)firmwareItems);
        Assert.assertTrue((firmwareItems.length > 0 ? 1 : 0) != 0);
        LOGGER.info("Current firmwareItems: {}", new Object[]{firmwareItems});
        String link = manufacturersStatusResponse.getLink();
        String filename = manufacturersStatusResponse.getFilename();
        LOGGER.info("Current nmraListDate: {}, lastUpdate: {}, filename: {}, link: {}", new Object[]{nmraListDate, lastUpdate, filename, link});
        ResponseEntity responseManufacturers = restTemplate.exchange(link, HttpMethod.GET, request, ManufacturersList.class, new Object[0]);
        Assert.assertNotNull((Object)responseManufacturers);
        ManufacturersList manufacturersList = (ManufacturersList)responseManufacturers.getBody();
        Assert.assertNotNull((Object)manufacturersList);
        LOGGER.info("Current manufacturersList: {}", (Object)manufacturersList);
        Assert.assertNotNull((Object)manufacturersList.getManufacturers());
        ManufacturersType manufacturersType = manufacturersList.getManufacturers();
        List manufacturers = manufacturersType.getManufacturer();
        Assert.assertTrue((manufacturers.size() > 0 ? 1 : 0) != 0);
    }

    private RestTemplate createRestTemplate(String restServiceUri) throws MalformedURLException, URISyntaxException {
        HttpHost myProxy = null;
        Proxy proxy = this.findProxy(new URL(REST_SERVICE_URI).toURI());
        if (!Proxy.NO_PROXY.equals(proxy)) {
            try {
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                String proxyUrl = addr.getHostName();
                int port = addr.getPort();
                myProxy = new HttpHost(proxyUrl, port);
            }
            catch (Exception ex) {
                LOGGER.warn("Prepare proxy HttpHost failed.", (Throwable)ex);
            }
        }
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (myProxy != null) {
            clientBuilder.setProxy(myProxy);
        }
        clientBuilder.disableCookieManagement();
        CloseableHttpClient httpClient = clientBuilder.build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setHttpClient((HttpClient)httpClient);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    @Test
    public void proxyTest() throws URISyntaxException, MalformedURLException {
        URL url = new URL("http://www.bidib.org");
        Proxy proxy = this.findProxy(url.toURI());
        LOGGER.info("Current proxy: {}", (Object)proxy);
        if (!Proxy.NO_PROXY.equals(proxy)) {
            try {
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                Properties systemSettings = System.getProperties();
                systemSettings.put("proxySet", "true");
                systemSettings.put("http.proxyHost", addr.getHostName());
                systemSettings.put("http.proxyPort", Integer.toString(addr.getPort()));
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                LOGGER.info(con.getResponseCode() + " : " + con.getResponseMessage());
                LOGGER.info("HTTP_OK: {} ", (Object)(con.getResponseCode() == 200 ? 1 : 0));
            }
            catch (Exception e) {
                LOGGER.warn("Check connection failed.", (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private Proxy findProxy(URI uri) throws URISyntaxException {
        ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
        ProxySelector proxySelector = proxySearch.getProxySelector();
        if (proxySelector == null) {
            LOGGER.info("No proxy selector available.");
            return Proxy.NO_PROXY;
        }
        ProxySelector.setDefault(proxySelector);
        Proxy proxy = ProxySelector.getDefault().select(uri).iterator().next();
        LOGGER.info("proxy type: {}", (Object)proxy.type());
        InetSocketAddress addr = (InetSocketAddress)proxy.address();
        if (addr == null) {
            LOGGER.info("No Proxy");
            return Proxy.NO_PROXY;
        }
        LOGGER.info("proxy hostname: {}", (Object)addr.getHostName());
        LOGGER.info("proxy port: {}", (Object)addr.getPort());
        return proxy;
    }
}

