/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.decoderdb;

import com.github.markusbernhardt.proxy.ProxySearch;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.bidib.jbidibc.decoder.exception.DecoderDbAccessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractDecoderDbAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDecoderDbAccess.class);
    protected static final String REST_SERVICE_URI = "https://www.decoderdb.de";
    private boolean proxyNeedsUserAndPassword;

    public <T> T fetch(String login, char[] password, String baseUrl, String urlPath, Class<T> responseType) {
        String plainCreds = login + ":" + String.copyValueOf(password);
        byte[] plainCredsBytes = plainCreds.getBytes();
        byte[] base64CredsBytes = Base64.encodeBase64((byte[])plainCredsBytes);
        String base64Creds = new String(base64CredsBytes);
        LOGGER.info("base64Creds: {}", (Object)base64Creds);
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", "Basic " + base64Creds);
        try {
            RestTemplate restTemplate = this.createRestTemplate(baseUrl);
            HttpEntity request = new HttpEntity((MultiValueMap)headers);
            ResponseEntity response = restTemplate.exchange(baseUrl + urlPath, HttpMethod.GET, request, responseType, new Object[0]);
            Object responseBody = response.getBody();
            LOGGER.info("Retrieved responseBody: {}", responseBody);
            return (T)responseBody;
        }
        catch (MalformedURLException | URISyntaxException ex) {
            LOGGER.warn("Fetch data from decoderDb failed.", (Throwable)ex);
            throw new DecoderDbAccessException("Fetch data from decoderDb failed.", ex);
        }
    }

    protected RestTemplate createRestTemplate(String restServiceUri) throws MalformedURLException, URISyntaxException {
        BasicCredentialsProvider credsProvider = null;
        if (this.proxyNeedsUserAndPassword) {
            String username = "username";
            String password = "pa$$word";
            String proxyUrl = "proxy.nyc.bigtower.com";
            int port = 8080;
            credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope("proxy.nyc.bigtower.com", 8080), (Credentials)new UsernamePasswordCredentials("username", "pa$$word"));
        }
        HttpHost myProxy = null;
        Proxy proxy = this.findProxy(new URL(REST_SERVICE_URI).toURI());
        if (!Proxy.NO_PROXY.equals(proxy)) {
            try {
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                String proxyUrl = addr.getHostName();
                int port = addr.getPort();
                myProxy = new HttpHost(proxyUrl, port);
            }
            catch (Exception ex) {
                LOGGER.warn("Prepare proxy HttpHost failed.", (Throwable)ex);
            }
        }
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (myProxy != null) {
            clientBuilder.setProxy(myProxy);
            if (credsProvider != null) {
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
        }
        clientBuilder.disableCookieManagement();
        CloseableHttpClient httpClient = clientBuilder.build();
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory();
        factory.setHttpClient((HttpClient)httpClient);
        return new RestTemplate((ClientHttpRequestFactory)factory);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Proxy findProxy(URI uri) throws URISyntaxException {
        ProxySearch proxySearch = ProxySearch.getDefaultProxySearch();
        ProxySelector proxySelector = proxySearch.getProxySelector();
        if (proxySelector == null) {
            LOGGER.info("No proxy selector available.");
            return Proxy.NO_PROXY;
        }
        ProxySelector.setDefault(proxySelector);
        Proxy proxy = ProxySelector.getDefault().select(uri).iterator().next();
        LOGGER.info("proxy type: {}", (Object)proxy.type());
        InetSocketAddress addr = (InetSocketAddress)proxy.address();
        if (addr == null) {
            LOGGER.info("No Proxy");
            return Proxy.NO_PROXY;
        }
        LOGGER.info("proxy hostname: {}", (Object)addr.getHostName());
        LOGGER.info("proxy port: {}", (Object)addr.getPort());
        return proxy;
    }
}

