/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.version;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bidib.jbidibc.decoder.version.DecoderVersion;
import org.bidib.jbidibc.decoder.version.PatternAVersion;
import org.bidib.jbidibc.decoder.version.PatternBVersion;
import org.bidib.jbidibc.decoder.version.PatternCVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionMatcher.class);
    public static final String PATTERN_A = "^([0-9]{1,4})$";
    public static final String PATTERN_B = "^([0-9]\\.?){1,3}$";
    public static final String PATTERN_C = "^V([0-9]\\.?){1,2}(R[0-9]+)$";
    public static Function<VersionCheck, String> versionMatcher = versionCheck -> {
        Matcher m = Pattern.compile(((VersionCheck)versionCheck).pattern).matcher(((VersionCheck)versionCheck).versionString);
        if (m.matches()) {
            LOGGER.info("The pattern matches!");
            return m.group();
        }
        return null;
    };

    public DecoderVersion detectVersion(String versionString) {
        VersionCheck versionCheck = new VersionCheck(PATTERN_A, versionString);
        String result = versionCheck.check(versionMatcher);
        if (result != null) {
            LOGGER.info("Found version of pattern A: {}", (Object)result);
            PatternAVersion version = new PatternAVersion(versionString);
            version.parse(result);
            return version;
        }
        versionCheck = new VersionCheck(PATTERN_B, versionString);
        result = versionCheck.check(versionMatcher);
        if (result != null) {
            LOGGER.info("Found version of pattern B: {}", (Object)result);
            PatternBVersion version = new PatternBVersion(versionString);
            version.parse(result);
            return version;
        }
        versionCheck = new VersionCheck(PATTERN_C, versionString);
        result = versionCheck.check(versionMatcher);
        if (result != null) {
            LOGGER.info("Found version of pattern C: {}", (Object)result);
            PatternCVersion version = new PatternCVersion(versionString);
            version.parse(result);
            return version;
        }
        return null;
    }

    public static class VersionCheck {
        private final String versionString;
        private final String pattern;

        public VersionCheck(String pattern, String versionString) {
            this.pattern = pattern;
            this.versionString = versionString;
        }

        public String check(Function<VersionCheck, String> fun) {
            return fun.apply(this);
        }
    }
}

