package org.bidib.jbidibc.decoder.schema.firmware;

import org.bidib.jbidibc.core.schema.exception.InvalidContentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FirmwareDefinitionTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FirmwareDefinitionTest.class);

    @Test
    public void loadFirmwareDefinition() {
        String filePath = "/decoder/Firmware_13_DecoderDB_1.0.xml";

        filePath = FirmwareDefinitionTest.class.getResource(filePath).getPath();
        LOGGER.info("Load firmwareDefinition from path: {}", filePath);

        FirmwareDefinitionFactory factory = new FirmwareDefinitionFactory();
        FirmwareDefinition firmwareDefinition = factory.loadFirmwareDefinition(filePath);

        Assert.assertNotNull(firmwareDefinition);
    }

    @Test
    public void loadFirmwareDefinition2() {
        String filePath = "/decoder/Firmware_97_1.06_sound.xml";

        filePath = FirmwareDefinitionTest.class.getResource(filePath).getPath();
        LOGGER.info("Load firmwareDefinition from path: {}", filePath);

        FirmwareDefinitionFactory factory = new FirmwareDefinitionFactory();
        FirmwareDefinition firmwareDefinition = factory.loadFirmwareDefinition(filePath);

        Assert.assertNotNull(firmwareDefinition);
    }

    @Test(expectedExceptions = InvalidContentException.class)
    public void loadFirmwareDefinition3() {
        String filePath = "/decoder/InvalidFirmwareDefinition_97_2.1.xml";

        filePath = FirmwareDefinitionTest.class.getResource(filePath).getPath();
        LOGGER.info("Load firmwareDefinition from path: {}", filePath);

        FirmwareDefinitionFactory factory = new FirmwareDefinitionFactory();
        FirmwareDefinition firmwareDefinition = factory.loadFirmwareDefinition(filePath);

        Assert.assertNotNull(firmwareDefinition);
    }

    @Test
    public void loadFirmwareDefinition4() {
        String filePath = "/decoder/Firmware_97_3.06.xml";

        filePath = FirmwareDefinitionTest.class.getResource(filePath).getPath();
        LOGGER.info("Load firmwareDefinition from path: {}", filePath);

        FirmwareDefinitionFactory factory = new FirmwareDefinitionFactory();
        FirmwareDefinition firmwareDefinition = factory.loadFirmwareDefinition(filePath);

        Assert.assertNotNull(firmwareDefinition);
    }
}
