package org.bidib.jbidibc.decoder.schema.product;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProductDefinitionFactoryTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(ProductDefinitionFactoryTest.class);

    @Test
    public void loadProductDefinitionTest() {
        String filePath = "/decoder/Product_97_DH05C.xml";

        filePath = ProductDefinitionFactoryTest.class.getResource(filePath).getPath();
        LOGGER.info("Load productDefinition from path: {}", filePath);

        ProductDefinitionFactory factory = new ProductDefinitionFactory();
        ProductDefinition productDefinition = factory.loadProductDefinition(filePath);

        Assert.assertNotNull(productDefinition);
    }
}
