/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.schema.decoder;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.exception.InvalidContentException;
import org.bidib.jbidibc.core.schema.exception.InvalidSchemaException;
import org.bidib.jbidibc.core.schema.validation.XsdValidationLoggingErrorHandler;
import org.bidib.jbidibc.decoder.schema.decoder.DecoderDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DecoderDefinitionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderDefinitionFactory.class);
    private static JAXBContext jaxbContext;
    private static final String JAXB_PACKAGE = "org.bidib.jbidibc.decoder.schema.decoder";
    public static final String XSD_LOCATION = "/xsd/decoder.xsd";

    public DecoderDefinition loadDecoderDefinition(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            LOGGER.error("The DecoderDefinition file must be specified!");
            return null;
        }
        LOGGER.info("Load DecoderDefinition from file: {}", (Object)filePath);
        DecoderDefinition decoderDefinition = null;
        FileInputStream is = null;
        File file = null;
        try {
            file = new File(filePath);
            is = new FileInputStream(file);
            decoderDefinition = this.loadDecoderDefinitionFile(is);
            LOGGER.trace("Loaded DecoderDefinition: {}", (Object)decoderDefinition);
        }
        catch (InvalidSchemaException ex) {
            LOGGER.warn("Load saved DecoderDefinition from file failed with schema exception: {}", (Object)ex.getMessage());
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Close input stream failed.", (Throwable)e);
                }
                is = null;
            }
            if (file != null) {
                try {
                    is = new FileInputStream(file);
                    List<String> errors = this.validateDecoderDefinitionFile(is, filePath);
                    throw new InvalidContentException("Validation of DecoderDefinition file failed: " + filePath, errors);
                }
                catch (FileNotFoundException e) {
                    LOGGER.warn("Load saved DecoderDefinition for validation from file failed: {}", (Object)e.getMessage());
                }
            }
        }
        catch (FileNotFoundException | IllegalArgumentException ex) {
            LOGGER.warn("Load saved DecoderDefinition from file failed: {}", (Object)ex.getMessage());
        }
        catch (InvalidContentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Load saved DecoderDefinition from file failed: {}", (Object)ex.getMessage());
        }
        return decoderDefinition;
    }

    protected String getProductDefinitionFileName() {
        return "test";
    }

    private List<String> validateDecoderDefinitionFile(InputStream is, String filePath) {
        LOGGER.info("Validate decoderDefinition file: {}", (Object)filePath);
        List errors = null;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new File(DecoderDefinitionFactory.class.getResource(XSD_LOCATION).getPath()));
            StreamSource streamSource = new StreamSource(is);
            Validator validator = schema.newValidator();
            XsdValidationLoggingErrorHandler errorHandler = new XsdValidationLoggingErrorHandler();
            validator.setErrorHandler((ErrorHandler)errorHandler);
            validator.validate(streamSource);
            errors = errorHandler.getErrors();
        }
        catch (Exception ex) {
            LOGGER.warn("Validate ProductDefinition from file failed: {}", (Object)this.getProductDefinitionFileName(), (Object)ex);
            throw new InvalidSchemaException("Load ProductDefinition from file failed.");
        }
        return errors;
    }

    private DecoderDefinition loadDecoderDefinitionFile(InputStream is) {
        LOGGER.info("Load DecoderDefinition file.");
        DecoderDefinition decoderDefinition = null;
        try {
            if (jaxbContext == null) {
                LOGGER.info("Create the jaxb context for DecoderDefinition.");
                jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(new File(DecoderDefinitionFactory.class.getResource(XSD_LOCATION).getPath()));
            unmarshaller.setSchema(schema);
            decoderDefinition = (DecoderDefinition)unmarshaller.unmarshal(is);
        }
        catch (UnmarshalException ex) {
            LOGGER.warn("Load DecoderDefinition from file failed with UnmarshalException.", (Throwable)ex);
            if (ex.getCause() instanceof SAXParseException) {
                throw new InvalidSchemaException("Load DecoderDefinition from file failed");
            }
            throw new IllegalArgumentException("Load DecoderDefinition from file failed with UnmarshalException.");
        }
        catch (JAXBException | SAXException ex) {
            LOGGER.warn("Load DecoderDefinition from file failed: {}", (Object)this.getProductDefinitionFileName(), (Object)ex);
            throw new InvalidSchemaException("Load DecoderDefinition from file failed: " + this.getProductDefinitionFileName());
        }
        catch (Exception ex) {
            LOGGER.warn("Load DecoderDefinition from file failed: {}", (Object)this.getProductDefinitionFileName(), (Object)ex);
            throw new RuntimeException("Load DecoderDefinition from file failed: " + this.getProductDefinitionFileName());
        }
        return decoderDefinition;
    }
}

