/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.decoderdb;

import java.util.List;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.decoder.decoderdb.ManufacturerAccess;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturerType;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersList;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManufacturerAccessTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManufacturerAccessTest.class);

    @Test
    public void fetch() {
        LOGGER.info("Fetch manufacturers from DecoderDB.");
        ManufacturerAccess manufacturerAccess = new ManufacturerAccess();
        ManufacturersList listManufacturers = manufacturerAccess.fetch("cv", "cv".toCharArray());
        LOGGER.info("Retrieved listManufacturers: {}", (Object)listManufacturers);
        Assertions.assertThat((Object)listManufacturers).isNotNull();
        Assertions.assertThat((Object)listManufacturers.getManufacturers()).isNotNull();
        Assertions.assertThat((List)listManufacturers.getManufacturers().getManufacturer()).isNotNull();
        Assertions.assertThat((List)listManufacturers.getManufacturers().getManufacturer()).isNotEmpty();
        int ID = 13;
        List manufacturers = listManufacturers.getManufacturers().getManufacturer();
        ManufacturerType manufacturerDiy = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13;
            }
        });
        Assertions.assertThat((Object)manufacturerDiy).isNotNull();
        LOGGER.info("Found DIY manufacturer: {}", (Object)manufacturerDiy);
        final Integer EXTENDED_ID_OPENDCC = 258;
        ManufacturerType manufacturerOpenDcc = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13 && EXTENDED_ID_OPENDCC.equals(manufacturer.getExtendedId());
            }
        });
        Assertions.assertThat((Object)manufacturerOpenDcc).isNotNull();
        LOGGER.info("Found OpenDCC manufacturer: {}", (Object)manufacturerOpenDcc);
    }
}

