/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.schema.nmramanufacturers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.bidib.jbidibc.core.schema.exception.InvalidContentException;
import org.bidib.jbidibc.core.schema.exception.InvalidSchemaException;
import org.bidib.jbidibc.core.schema.validation.XsdValidationLoggingErrorHandler;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class NMRAManufacturersFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(NMRAManufacturersFactory.class);
    private static JAXBContext jaxbContext;
    private static final String JAXB_PACKAGE = "org.bidib.jbidibc.decoder.schema.manufacturers";
    public static final String XSD_LOCATION = "/xsd/manufacturers.xsd";
    public static final String XSD_LOCATION_COMMON_TYPES = "/xsd/commonTypes.xsd";
    public static final String DEFAULT_MANUFACTURERES_FILE = "/manufacturers/Manufacturers.xml";

    public ManufacturersList loadNmraManufacturers(String filePath) {
        if (StringUtils.isBlank((CharSequence)filePath)) {
            LOGGER.error("The NmraManufacturers file must be specified!");
            return null;
        }
        LOGGER.info("Load NmraManufacturers from file: {}", (Object)filePath);
        ManufacturersList nmraManufacturers = null;
        FileInputStream is = null;
        File file = null;
        try {
            file = new File(filePath);
            is = new FileInputStream(file);
            nmraManufacturers = this.loadNmraManufacturersFile(is, filePath);
            LOGGER.trace("Loaded nmraManufacturers: {}", (Object)nmraManufacturers);
        }
        catch (InvalidSchemaException ex) {
            LOGGER.warn("Load saved NmraManufacturers from file failed with schema exception: {}", (Object)ex.getMessage());
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Close input stream failed.", (Throwable)e);
                }
                is = null;
            }
            if (file != null) {
                try {
                    is = new FileInputStream(file);
                    List<String> errors = this.validateNmraManufacturersFile(is, filePath);
                    throw new InvalidContentException("Validation of NmraManufacturers file failed: " + filePath, errors);
                }
                catch (FileNotFoundException e) {
                    LOGGER.warn("Load saved NmraManufacturers for validation from file failed: {}", (Object)e.getMessage());
                }
            }
        }
        catch (FileNotFoundException | IllegalArgumentException ex) {
            LOGGER.warn("Load saved NmraManufacturers from file failed: {}", (Object)ex.getMessage());
        }
        catch (InvalidContentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Load saved NmraManufacturers from file failed: {}", (Object)ex.getMessage());
        }
        return nmraManufacturers;
    }

    public ManufacturersList loadNmraManufacturers() {
        ManufacturersList nmraManufacturers = null;
        InputStream is = null;
        try {
            is = NMRAManufacturersFactory.class.getResourceAsStream(DEFAULT_MANUFACTURERES_FILE);
            nmraManufacturers = this.loadNmraManufacturersFile(is, DEFAULT_MANUFACTURERES_FILE);
            LOGGER.trace("Loaded nmraManufacturers: {}", (Object)nmraManufacturers);
        }
        catch (InvalidSchemaException ex) {
            LOGGER.warn("Load saved NmraManufacturers from file failed with schema exception: {}", (Object)ex.getMessage());
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOGGER.warn("Close input stream failed.", (Throwable)e);
                }
                is = null;
            }
            is = NMRAManufacturersFactory.class.getResourceAsStream(DEFAULT_MANUFACTURERES_FILE);
            List<String> errors = this.validateNmraManufacturersFile(is, DEFAULT_MANUFACTURERES_FILE);
            throw new InvalidContentException("Validation of NmraManufacturers file failed: /manufacturers/Manufacturers.xml", errors);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Load saved NmraManufacturers from file failed: {}", (Object)ex.getMessage());
        }
        catch (InvalidContentException ex) {
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.warn("Load saved NmraManufacturers from file failed: {}", (Object)ex.getMessage());
        }
        return nmraManufacturers;
    }

    private List<String> validateNmraManufacturersFile(InputStream is, String filePath) {
        LOGGER.info("Validate NmraManufacturers file: {}", (Object)filePath);
        List errors = null;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSourceSchemaCommonTypes = new StreamSource(NMRAManufacturersFactory.class.getResourceAsStream(XSD_LOCATION_COMMON_TYPES));
            StreamSource streamSourceSchema = new StreamSource(NMRAManufacturersFactory.class.getResourceAsStream(XSD_LOCATION));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceSchemaCommonTypes, streamSourceSchema});
            StreamSource streamSource = new StreamSource(is);
            Validator validator = schema.newValidator();
            XsdValidationLoggingErrorHandler errorHandler = new XsdValidationLoggingErrorHandler();
            validator.setErrorHandler((ErrorHandler)errorHandler);
            validator.validate(streamSource);
            errors = errorHandler.getErrors();
        }
        catch (Exception ex) {
            LOGGER.warn("Validate NmraManufacturers from file failed: {}", (Object)filePath, (Object)ex);
            throw new InvalidSchemaException("Load NmraManufacturers from file failed.");
        }
        return errors;
    }

    private ManufacturersList loadNmraManufacturersFile(InputStream is, String filePath) {
        LOGGER.info("Load NmraManufacturers file, filePath: {}", (Object)filePath);
        ManufacturersList nmraManufacturers = null;
        try {
            if (jaxbContext == null) {
                LOGGER.info("Create the jaxb context for NmraManufacturers.");
                jaxbContext = JAXBContext.newInstance((String)JAXB_PACKAGE);
            }
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            StreamSource streamSourceSchemaCommonTypes = new StreamSource(NMRAManufacturersFactory.class.getResourceAsStream(XSD_LOCATION_COMMON_TYPES));
            StreamSource streamSourceSchema = new StreamSource(NMRAManufacturersFactory.class.getResourceAsStream(XSD_LOCATION));
            Schema schema = schemaFactory.newSchema(new Source[]{streamSourceSchemaCommonTypes, streamSourceSchema});
            unmarshaller.setSchema(schema);
            nmraManufacturers = (ManufacturersList)unmarshaller.unmarshal(is);
        }
        catch (UnmarshalException ex) {
            LOGGER.warn("Load NmraManufacturers from file failed with UnmarshalException.", (Throwable)ex);
            if (ex.getCause() instanceof SAXParseException) {
                throw new InvalidSchemaException("Load NmraManufacturers from file failed");
            }
            throw new IllegalArgumentException("Load NmraManufacturers from file failed with UnmarshalException.");
        }
        catch (JAXBException | SAXException ex) {
            LOGGER.warn("Load NmraManufacturers from file failed: {}", (Object)filePath, (Object)ex);
            throw new InvalidSchemaException("Load NmraManufacturers from file failed: " + filePath);
        }
        catch (Exception ex) {
            LOGGER.warn("Load NmraManufacturers from file failed: {}", (Object)filePath, (Object)ex);
            throw new RuntimeException("Load NmraManufacturers from file failed: " + filePath);
        }
        return nmraManufacturers;
    }
}

