/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.schema.decoderfirmware;

import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.core.schema.exception.InvalidContentException;
import org.bidib.jbidibc.decoder.schema.decoderfirmware.DecoderFirmwareDefinition;
import org.bidib.jbidibc.decoder.schema.decoderfirmware.DecoderFirmwareDefinitionFactory;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderFirmwareDefinitionTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderFirmwareDefinitionTest.class);

    @Test
    public void loadFirmwareDefinition2() {
        String filePath = "/firmware/97/Firmware_97_1.06_sound.xml";
        filePath = DecoderFirmwareDefinitionTest.class.getResource(filePath).getPath();
        LOGGER.info("Load firmwareDefinition from path: {}", (Object)filePath);
        DecoderFirmwareDefinitionFactory factory = new DecoderFirmwareDefinitionFactory();
        DecoderFirmwareDefinition firmwareDefinition = factory.loadFirmwareDefinition(filePath);
        Assertions.assertThat((Object)firmwareDefinition).isNotNull();
    }

    @Test
    public void loadFirmwareDefinition3() {
        String filePath = "/firmware/invalid/Firmware_invalid_1.0.xml";
        String resourcePath = DecoderFirmwareDefinitionTest.class.getResource(filePath).getPath();
        LOGGER.info("Load firmwareDefinition from path: {}", (Object)resourcePath);
        DecoderFirmwareDefinitionFactory factory = new DecoderFirmwareDefinitionFactory();
        Assertions.assertThatThrownBy(() -> factory.loadFirmwareDefinition(resourcePath)).isInstanceOf(InvalidContentException.class);
    }

    @Test
    public void loadFirmwareDefinition4() {
        String filePath = "/firmware/97/Firmware_97_3.06.xml";
        filePath = DecoderFirmwareDefinitionTest.class.getResource(filePath).getPath();
        LOGGER.info("Load firmwareDefinition from path: {}", (Object)filePath);
        DecoderFirmwareDefinitionFactory factory = new DecoderFirmwareDefinitionFactory();
        DecoderFirmwareDefinition firmwareDefinition = factory.loadFirmwareDefinition(filePath);
        Assertions.assertThat((Object)firmwareDefinition).isNotNull();
    }
}

