/*
 * Decompiled with CFR 0.152.
 */
package org.bidib.jbidibc.decoder.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.collections4.IterableUtils;
import org.apache.commons.collections4.Predicate;
import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.decoder.decoderdb.AbstractDecoderDbAccess;
import org.bidib.jbidibc.decoder.decoderdb.ProxyUtils;
import org.bidib.jbidibc.decoder.json.DecoderDbStatusResponse;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturerType;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersList;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersType;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class DecoderDbStatusResponseTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderDbStatusResponseTest.class);
    private static final String REST_SERVICE_URI = "https://www.decoderdb.de";

    @Test
    @Order(value=1)
    public void listAll() throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        mapper.registerModule((Module)module);
        InputStream is = DecoderDbStatusResponseTest.class.getResourceAsStream("/json/listAll.json");
        DecoderDbStatusResponse listAll = (DecoderDbStatusResponse)mapper.readValue(is, DecoderDbStatusResponse.class);
        LOGGER.info("Loaded listAll: {}", (Object)listAll);
        Assertions.assertThat((Object)listAll).isNotNull();
        Assertions.assertThat((Object)listAll.getManufacturers()).isNotNull();
        Assertions.assertThat((String)listAll.getManufacturers().getFilename()).isEqualTo("Manufacturers.xml");
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.set(2016, 4, 19, 0, 0, 0);
        cal.set(14, 0);
        Assertions.assertThat((Date)listAll.getManufacturers().getNmraListDate()).isEqualTo((Object)cal.getTime());
        Assertions.assertThat((boolean)listAll.getManufacturers().isValid()).isTrue();
        Assertions.assertThat((Object)listAll.getDecoderDetections()).isNotNull();
        Assertions.assertThat((String)listAll.getDecoderDetections().getFilename()).isEqualTo("decoderDetection.xml");
        Assertions.assertThat((String)listAll.getDecoderDetections().getLink()).isEqualTo("https://www.decoderdb.de/?decoderdetection");
        Assertions.assertThat((boolean)listAll.getDecoderDetections().isValid()).isTrue();
        Assertions.assertThat((Object[])listAll.getDecoder()).isNotNull();
        Assertions.assertThat((int)listAll.getDecoder().length).isEqualTo(15);
        DecoderDbStatusResponse.DecoderStatusResponse product = listAll.getDecoder()[0];
        Assertions.assertThat((Object)product).isNotNull();
        Assertions.assertThat((String)product.getFilename()).isEqualTo("Product_0_NMRA-Standard.xml");
        Assertions.assertThat((Integer)product.getManufacturerId()).isEqualTo((Object)0);
        Assertions.assertThat((Integer)product.getManufacturerExtendedId()).isNull();
        Assertions.assertThat((String)product.getName()).isEqualTo("NMRA-Standard");
        product = listAll.getDecoder()[1];
        Assertions.assertThat((Object)product).isNotNull();
        Assertions.assertThat((String)product.getFilename()).isEqualTo("Product_13-256_DecoderDBLok.xml");
        Assertions.assertThat((Integer)product.getManufacturerId()).isEqualTo((Object)13);
        Assertions.assertThat((Integer)product.getManufacturerExtendedId()).isEqualTo((Object)256);
        Assertions.assertThat((String)product.getName()).isEqualTo("Decoder DB Lok");
    }

    @Test
    @Disabled
    @Order(value=2)
    public void listManufacturersRemote() throws MalformedURLException, URISyntaxException {
        LOGGER.info("listManufacturersRemote");
        ManufacturersList listManufacturers = (ManufacturersList)AbstractDecoderDbAccess.fetch((String)"cv", (char[])"cv".toCharArray(), (String)"https://www.decoderdb.de/?manufacturers", ManufacturersList.class, (AbstractDecoderDbAccess.DataFormat)AbstractDecoderDbAccess.DataFormat.xml);
        LOGGER.info("Retrieved listManufacturers: {}", (Object)listManufacturers);
        Assertions.assertThat((Object)listManufacturers).isNotNull();
        Assertions.assertThat((Object)listManufacturers.getManufacturers()).isNotNull();
        Assertions.assertThat((List)listManufacturers.getManufacturers().getManufacturer()).isNotNull();
        Assertions.assertThat((List)listManufacturers.getManufacturers().getManufacturer()).isNotEmpty();
        int ID = 13;
        List manufacturers = listManufacturers.getManufacturers().getManufacturer();
        ManufacturerType manufacturerDiy = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13;
            }
        });
        Assertions.assertThat((Object)manufacturerDiy).isNotNull();
        LOGGER.info("Found DIY manufacturer: {}", (Object)manufacturerDiy);
        final Integer EXTENDED_ID_OPENDCC = 258;
        ManufacturerType manufacturerOpenDcc = (ManufacturerType)IterableUtils.find((Iterable)manufacturers, (Predicate)new Predicate<ManufacturerType>(){

            public boolean evaluate(ManufacturerType manufacturer) {
                return manufacturer.getId() == 13 && EXTENDED_ID_OPENDCC.equals(manufacturer.getExtendedId());
            }
        });
        Assertions.assertThat((Object)manufacturerOpenDcc).isNotNull();
        LOGGER.info("Found OpenDCC manufacturer: {}", (Object)manufacturerOpenDcc);
    }

    @Test
    @Disabled
    @Order(value=2)
    public void listAllRemote() throws MalformedURLException, URISyntaxException {
        LOGGER.info("listAllRemote");
        DecoderDbStatusResponse listAll = (DecoderDbStatusResponse)AbstractDecoderDbAccess.fetch((String)"cv", (char[])"cv".toCharArray(), (String)"https://www.decoderdb.de/?listAll", DecoderDbStatusResponse.class, (AbstractDecoderDbAccess.DataFormat)AbstractDecoderDbAccess.DataFormat.json);
        LOGGER.info("Retrieved listAll: {}", (Object)listAll);
        DecoderDbStatusResponse.ManufacturersStatusResponse manufacturersStatusResponse = listAll.getManufacturers();
        Assertions.assertThat((Object)manufacturersStatusResponse).isNotNull();
        Date nmraListDate = manufacturersStatusResponse.getNmraListDate();
        Assertions.assertThat((Date)nmraListDate).isNotNull();
        Date lastUpdate = manufacturersStatusResponse.getLastUpdate();
        Assertions.assertThat((Date)lastUpdate).isNotNull();
        Object[] decoders = listAll.getDecoder();
        Assertions.assertThat((Object[])decoders).isNotNull();
        Assertions.assertThat((decoders.length > 0 ? 1 : 0) != 0).isTrue();
        LOGGER.info("Current decoders: {}", new Object[]{decoders});
        Object[] firmwareItems = listAll.getFirmware();
        Assertions.assertThat((Object[])firmwareItems).isNotNull();
        Assertions.assertThat((firmwareItems.length > 0 ? 1 : 0) != 0).isTrue();
        LOGGER.info("Current firmwareItems: {}", new Object[]{firmwareItems});
        String link = manufacturersStatusResponse.getLink();
        String filename = manufacturersStatusResponse.getFilename();
        LOGGER.info("Current nmraListDate: {}, lastUpdate: {}, filename: {}, link: {}", new Object[]{nmraListDate, lastUpdate, filename, link});
        ManufacturersList manufacturersList = (ManufacturersList)AbstractDecoderDbAccess.fetch((String)"cv", (char[])"cv".toCharArray(), (String)link, ManufacturersList.class, (AbstractDecoderDbAccess.DataFormat)AbstractDecoderDbAccess.DataFormat.xml);
        Assertions.assertThat((Object)manufacturersList).isNotNull();
        LOGGER.info("Current manufacturersList: {}", (Object)manufacturersList);
        Assertions.assertThat((Object)manufacturersList.getManufacturers()).isNotNull();
        ManufacturersType manufacturersType = manufacturersList.getManufacturers();
        List manufacturers = manufacturersType.getManufacturer();
        Assertions.assertThat((List)manufacturers).hasSizeGreaterThan(0);
    }

    @Test
    public void proxyTest() throws URISyntaxException, MalformedURLException {
        URL url = new URL("http://www.bidib.org");
        Proxy proxy = ProxyUtils.findProxy((URI)url.toURI());
        LOGGER.info("Current proxy: {}", (Object)proxy);
        if (!Proxy.NO_PROXY.equals(proxy)) {
            try {
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                Properties systemSettings = System.getProperties();
                systemSettings.put("proxySet", "true");
                systemSettings.put("http.proxyHost", addr.getHostName());
                systemSettings.put("http.proxyPort", Integer.toString(addr.getPort()));
                HttpURLConnection con = (HttpURLConnection)url.openConnection();
                LOGGER.info(con.getResponseCode() + " : " + con.getResponseMessage());
                LOGGER.info("HTTP_OK: {} ", (Object)(con.getResponseCode() == 200 ? 1 : 0));
            }
            catch (Exception e) {
                LOGGER.warn("Check connection failed.", (Throwable)e);
            }
        }
    }
}

