package org.bidib.jbidibc.decoder.schema.decoder;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderDefinitionFactoryTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(DecoderDefinitionFactoryTest.class);

    @Test
    public void loadDecoderDefinitionTest() {
        String filePath = "/decoder/97/Decoder_97_DH05C.decdb";

        filePath = DecoderDefinitionFactoryTest.class.getResource(filePath).getPath();
        LOGGER.info("Load productDefinition from path: {}", filePath);

        DecoderDefinitionFactory factory = new DecoderDefinitionFactory();
        DecoderDefinition decoderDefinition = factory.loadDecoderDefinition(filePath);

        Assertions.assertThat(decoderDefinition).isNotNull();
        DecoderType decoder = decoderDefinition.getDecoder();
        Assertions.assertThat(decoder).isNotNull();

        Assertions.assertThat(decoder.getName()).isEqualTo("DH05C");
    }
}
