package org.bidib.jbidibc.decoder.schema.nmramanufacturers;

import org.assertj.core.api.Assertions;
import org.bidib.jbidibc.decoder.schema.manufacturers.ManufacturersList;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMRAManufacturersFactoryTest {

    private static final Logger LOGGER = LoggerFactory.getLogger(NMRAManufacturersFactoryTest.class);

    @Test
    public void loadNMRAManufacturersTest() {
        String filePath = "/manufacturers/Manufacturers-test.xml";

        filePath = NMRAManufacturersFactoryTest.class.getResource(filePath).getPath();
        LOGGER.info("Load nmraManufacturers from path: {}", filePath);

        NMRAManufacturersFactory factory = new NMRAManufacturersFactory();
        ManufacturersList nmraManufacturers = factory.loadNmraManufacturers(filePath);

        Assertions.assertThat(nmraManufacturers).isNotNull();

        Assertions.assertThat(nmraManufacturers.getManufacturers()).isNotNull();
        Assertions.assertThat(nmraManufacturers.getManufacturers().getManufacturer()).isNotEmpty();
    }
}
